/*
 * Decompiled with CFR 0.152.
 */
package visualizer.converters;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import visualizer.util.OldPointsReader;
import visualizer.util.OpenDialog;
import visualizer.util.SaveDialog;
import visualizer.util.Util;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.NAMESFilter;

public class PointsFileConverterView
extends JFrame {
    private JButton convert_jButton;
    private JButton namesButton;
    private JLabel namesLabel;
    private JLabel namesLabel1;
    private JTextField namesTextField;
    private JTextField newPointsFile_TextField;
    private JButton newPointsFile_jButton;
    private JLabel newPointsLabel;
    private JButton pointsButton;
    private JTextField pointsTextField;

    public PointsFileConverterView() {
        this.initComponents();
    }

    private void initComponents() {
        this.namesLabel = new JLabel();
        this.namesTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.namesButton = new JButton();
        this.pointsButton = new JButton();
        this.namesLabel1 = new JLabel();
        this.newPointsLabel = new JLabel();
        this.newPointsFile_TextField = new JTextField();
        this.newPointsFile_jButton = new JButton();
        this.convert_jButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Points File Converter");
        this.getContentPane().setLayout(new GridBagLayout());
        this.namesLabel.setText("Old Names File");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.namesLabel, gridBagConstraints);
        this.namesTextField.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.namesTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pointsTextField, gridBagConstraints);
        this.namesButton.setText("Search...");
        this.namesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointsFileConverterView.this.namesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.namesButton, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointsFileConverterView.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pointsButton, gridBagConstraints);
        this.namesLabel1.setText("Old Points File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.namesLabel1, gridBagConstraints);
        this.newPointsLabel.setText("New Points File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.newPointsLabel, gridBagConstraints);
        this.newPointsFile_TextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.newPointsFile_TextField, gridBagConstraints);
        this.newPointsFile_jButton.setText("Set Filename");
        this.newPointsFile_jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointsFileConverterView.this.newPointsFile_jButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.newPointsFile_jButton, gridBagConstraints);
        this.convert_jButton.setText("Convert");
        this.convert_jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointsFileConverterView.this.convert_jButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.convert_jButton, gridBagConstraints);
        this.pack();
    }

    private void namesButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new NAMESFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.namesTextField.setText(filename);
        }
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.pointsTextField.setText(filename);
            String newFilename = filename.substring(0, filename.lastIndexOf("\\") + 1);
            newFilename = newFilename + "NEW_" + filename.substring(filename.lastIndexOf("\\") + 1, filename.length());
            this.newPointsFile_TextField.setText(newFilename);
        }
    }

    private void newPointsFile_jButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new DATAFilter(), this, "newPointsFilename");
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            this.newPointsFile_TextField.setText(filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convert_jButtonActionPerformed(ActionEvent evt) {
        BufferedWriter out = null;
        try {
            int i;
            Vector<String> names = Util.readOldNamesFile(this.namesTextField.getText());
            OldPointsReader opr = new OldPointsReader(this.pointsTextField.getText());
            float[][] points = opr.getPoints();
            Vector<String> attr = opr.getAttributes();
            float[] cdata = opr.getCdata();
            out = new BufferedWriter(new FileWriter(this.newPointsFile_TextField.getText()));
            out.write("DY");
            out.write("\r\n");
            out.write(Integer.toString(points.length));
            out.write("\r\n");
            out.write(Integer.toString(attr.size()));
            out.write("\r\n");
            for (i = 0; i < attr.size(); ++i) {
                out.write(attr.get(i) + ";");
            }
            out.write("\r\n");
            for (i = 0; i < points.length; ++i) {
                out.write(names.get(i) + ";");
                for (int j = 0; j < points[i].length; ++j) {
                    out.write(points[i][j] + ";");
                }
                out.write(Float.toString(cdata[i]));
                out.write("\r\n");
            }
        }
        catch (IOException ioE) {
            ioE.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PointsFileConverterView().setVisible(true);
            }
        });
    }
}

