/*
 * Decompiled with CFR 0.152.
 */
package visualizer.corpus.database;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.Corpus;
import visualizer.corpus.database.SqlManager;
import visualizer.textprocessing.Ngram;

public class DataBaseCorpus
extends Corpus {
    private int collection_id = 0;

    public DataBaseCorpus(String url, int nrGrams) {
        super(url, nrGrams);
        try {
            this.retrieveCollectionId();
            this.run();
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.INFO, "Collection name: " + this.url);
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.INFO, "Collection id: " + this.collection_id);
        }
        catch (IOException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getFullContent(String id) throws IOException {
        String content = "";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = SqlManager.getInstance().getSqlStatement("SELECT.CONTENT.DOCUMENT");
            stmt.setInt(1, Integer.parseInt(id));
            stmt.setInt(2, this.collection_id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                content = rs.getString("content");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
        return content;
    }

    @Override
    public String getFilteredContent(String id) throws IOException {
        return this.getFullContent(id);
    }

    @Override
    public String getViewContent(String id) throws IOException {
        return this.getFullContent(id);
    }

    @Override
    public String getSearchContent(String id) throws IOException {
        return this.getFullContent(id);
    }

    @Override
    public ArrayList<Ngram> getNgrams(String id) throws IOException {
        ArrayList ngrams = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = SqlManager.getInstance().getSqlStatement("SELECT.NGRAMS.DOCUMENT");
            stmt.setInt(1, Integer.parseInt(id));
            stmt.setInt(2, this.collection_id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                InputStream is = rs.getBlob("ngrams").getBinaryStream();
                ObjectInputStream ois = new ObjectInputStream(is);
                ngrams = (ArrayList)ois.readObject();
                ois.close();
                is.close();
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
        return ngrams;
    }

    @Override
    public ArrayList<Ngram> getCorpusNgrams() throws IOException {
        ArrayList ngrams = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = SqlManager.getInstance().getSqlStatement("SELECT.NGRAMS.COLLECTION");
            stmt.setInt(1, this.collection_id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                InputStream is = rs.getBlob("ngrams").getBinaryStream();
                ObjectInputStream ois = new ObjectInputStream(is);
                ngrams = (ArrayList)ois.readObject();
                ois.close();
                is.close();
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
        return ngrams;
    }

    public Date getDate(String id) throws IOException {
        java.sql.Date date = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = SqlManager.getInstance().getSqlStatement("SELECT.DATE.DOCUMENT");
            stmt.setInt(1, Integer.parseInt(id));
            stmt.setInt(2, this.collection_id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                date = rs.getDate("date");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
        return date;
    }

    public int getNrDocuments() throws IOException {
        int nrDocuments;
        block17: {
            nrDocuments = 0;
            if (this.collection_id > 0) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = SqlManager.getInstance().getSqlStatement("SELECT.NUMBER.DOCUMENTS");
                    stmt.setInt(1, this.collection_id);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        nrDocuments = rs.getInt(1);
                        break block17;
                    }
                    throw new IOException("Problems retrieving the number of documents.");
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                            throw new IOException(ex.getMessage());
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                            throw new IOException(ex.getMessage());
                        }
                    }
                }
            }
        }
        return nrDocuments;
    }

    @Override
    protected void run() {
        this.createFilenames();
        this.createCdata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFilenames() {
        if (this.url != null) {
            this.ids = new ArrayList();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = SqlManager.getInstance().getSqlStatement("SELECT.ID.DOCUMENTS");
                stmt.setInt(1, this.collection_id);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int id = rs.getInt("id");
                    this.ids.add(Integer.toString(id));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SQLException ex) {
                Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCdata() {
        if (this.url != null && this.ids != null) {
            float[] cdata = new float[this.ids.size()];
            Arrays.fill(cdata, 0.0f);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = SqlManager.getInstance().getSqlStatement("SELECT.CLASS.DOCUMENTS");
                stmt.setInt(1, this.collection_id);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    float value = rs.getFloat("class");
                    String id = Integer.toString(rs.getInt("id"));
                    cdata[this.ids.indexOf((Object)id)] = value;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SQLException ex) {
                Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            this.cdata = cdata;
        }
    }

    private void retrieveCollectionId() throws IOException {
        block17: {
            if (this.url != null) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = SqlManager.getInstance().getSqlStatement("SELECT.COLLECTION.BY.NAME");
                    stmt.setString(1, this.url);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        this.collection_id = rs.getInt("id");
                        break block17;
                    }
                    throw new IOException("There is not exist a collection called \"" + this.url + "\"");
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                            throw new IOException(ex.getMessage());
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                            throw new IOException(ex.getMessage());
                        }
                    }
                }
            }
        }
    }
}

