/*
 * Decompiled with CFR 0.152.
 */
package visualizer.corpus.zip;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import visualizer.corpus.Corpus;
import visualizer.corpus.zip.InvertedZipCorpus;
import visualizer.textprocessing.Ngram;

public class ZipCorpus
extends Corpus {
    private InvertedZipCorpus invCorpus;

    public ZipCorpus(String url, int nrGrams) {
        super(url, nrGrams);
        this.run();
        String invCorpFilename = this.url.substring(0, this.url.length() - 4) + ".inv";
        this.invCorpus = new InvertedZipCorpus(this, nrGrams, invCorpFilename);
    }

    @Override
    public String getViewContent(String itemUrl) throws IOException {
        return this.getFullContent(itemUrl);
    }

    @Override
    public String getSearchContent(String itemUrl) throws IOException {
        return this.getFullContent(itemUrl);
    }

    @Override
    public String getFullContent(String itemUrl) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(this.url);
            ZipEntry entry = zip.getEntry(itemUrl);
            if (entry != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry), Corpus.getEncoding().toString()));
                StringBuffer text = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    text.append(line + "\r\n");
                }
                String string = text.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw new IOException("File " + itemUrl + " does not exist.");
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    @Override
    public String getFilteredContent(String itemUrl) throws IOException {
        return this.getFullContent(itemUrl);
    }

    @Override
    public ArrayList<Ngram> getCorpusNgrams() throws IOException {
        return this.invCorpus.getCorpusNgrams();
    }

    @Override
    public ArrayList<Ngram> getNgrams(String filename) throws IOException {
        return this.invCorpus.getNgrams(filename);
    }

    @Override
    protected void run() {
        this.createFilenames();
        this.createCdata();
    }

    private void createCdata() {
        if (this.url != null && this.ids != null) {
            int i;
            ArrayList<String> initials_aux = new ArrayList<String>();
            for (int i2 = 0; i2 < this.ids.size(); ++i2) {
                String filename = (String)this.ids.get(i2);
                int begin = filename.lastIndexOf("/");
                if (begin > -1) {
                    filename = filename.substring(begin + 1);
                }
                String ini = filename;
                if (filename.length() > 2) {
                    ini = filename.substring(0, 2);
                }
                if (initials_aux.contains(ini)) continue;
                initials_aux.add(ini);
            }
            Object[] initials = new String[initials_aux.size()];
            for (i = 0; i < initials_aux.size(); ++i) {
                initials[i] = (String)initials_aux.get(i);
            }
            Arrays.sort(initials);
            if (initials.length > 1) {
                this.cdata = new float[this.ids.size()];
                for (i = 0; i < this.ids.size(); ++i) {
                    this.cdata[i] = -1.0f;
                    for (int j = 0; j < initials.length; ++j) {
                        String filename = (String)this.ids.get(i);
                        int begin = filename.lastIndexOf("/");
                        if (begin > -1) {
                            filename = filename.substring(begin + 1);
                        }
                        if (!filename.startsWith((String)initials[j])) continue;
                        this.cdata[i] = j;
                    }
                }
            } else {
                this.cdata = new float[this.ids.size()];
                Arrays.fill(this.cdata, 0.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFilenames() {
        if (this.url != null) {
            this.ids = new ArrayList();
            ZipFile zip = null;
            try {
                ArrayList<String> filenames_aux = new ArrayList<String>();
                zip = new ZipFile(this.url);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry2;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || (entry2 = zip.getEntry(entry.getName())) == null) continue;
                    filenames_aux.add(entry2.getName());
                }
                ArrayList<Integer> index_aux = new ArrayList<Integer>();
                for (int i = 0; i < filenames_aux.size(); ++i) {
                    index_aux.add(i);
                }
                int[] index = new int[filenames_aux.size()];
                int i = 0;
                for (int j = 0; j < index.length; ++j) {
                    int ind = (int)Math.pow(2.0, i);
                    if (ind >= index_aux.size()) {
                        ind = 0;
                    }
                    index[j] = (Integer)index_aux.get(ind);
                    index_aux.remove(ind);
                    ++i;
                }
                for (i = 0; i < filenames_aux.size(); ++i) {
                    this.ids.add(filenames_aux.get(index[i]));
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ZipCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ZipCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ZipCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

