/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.SaveDialog;
import visualizer.util.filefilter.EPSFilter;

public class DistanceHistogram
extends JDialog {
    private JFreeChart freechart;
    private JPanel panel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton saveImageButton;

    private DistanceHistogram(Dialog parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.saveImageButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Distance Histogram");
        this.setModal(true);
        this.saveImageButton.setText("Save Image");
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceHistogram.this.saveImageButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveImageButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceHistogram.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImageButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new EPSFilter(), this, "image.eps");
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(filename);
                EpsGraphics g = new EpsGraphics(filename, (OutputStream)out, 0, 0, this.panel.getWidth() + 1, this.panel.getHeight() + 1, ColorMode.COLOR_RGB);
                this.freechart.draw((Graphics2D)g, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.panel.getWidth() + 1, this.panel.getHeight() + 1));
                g.flush();
                g.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DistanceHistogram.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Problems saving the file", 0);
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DistanceHistogram.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public static DistanceHistogram getInstance(JDialog parent) {
        return new DistanceHistogram(parent);
    }

    public void display(DistanceMatrix dmat) {
        this.freechart = this.createChart(this.createDataset(dmat));
        this.freechart.removeLegend();
        this.panel = new ChartPanel(this.freechart);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setPreferredSize(new Dimension(500, 300));
        this.setSize(new Dimension(500, 300));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private IntervalXYDataset createDataset(DistanceMatrix dmat) {
        HistogramDataset histogramdataset = new HistogramDataset();
        int nrDistances = (dmat.getElementCount() * dmat.getElementCount() - dmat.getElementCount()) / 2;
        double[] ad = new double[nrDistances];
        int index = 0;
        for (int i = 0; i < dmat.getElementCount() - 1; ++i) {
            for (int j = dmat.getElementCount() - 1; j > i; --j) {
                ad[index] = (dmat.getDistance(i, j) - dmat.getMinDistance()) / (dmat.getMaxDistance() - dmat.getMinDistance());
                ++index;
            }
        }
        histogramdataset.addSeries((Comparable)((Object)""), ad, 200, 0.0, 1.0);
        return histogramdataset;
    }

    private JFreeChart createChart(IntervalXYDataset intervalxydataset) {
        JFreeChart chart = ChartFactory.createHistogram((String)"Distance Histogram", (String)"Distances Values", (String)"Occurences", (IntervalXYDataset)intervalxydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        xyplot.setDomainGridlinePaint((Paint)Color.BLACK);
        xyplot.setRangeGridlinePaint((Paint)Color.BLACK);
        xyplot.setOutlinePaint((Paint)Color.BLACK);
        xyplot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        xyplot.setBackgroundPaint((Paint)Color.white);
        xyplot.setDomainCrosshairVisible(true);
        xyplot.setRangeCrosshairVisible(true);
        XYBarRenderer xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
        xybarrenderer.setDrawBarOutline(false);
        return chart;
    }
}

