/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.io.IOException;
import visualizer.datamining.dataanalysis.Stress;
import visualizer.graph.Graph;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.Euclidean;

public class KruskalStress
extends Stress {
    @Override
    public float calculate(Matrix matrix, Dissimilarity diss, Graph graph) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.calculate(dmat, graph);
    }

    @Override
    public float calculate(DistanceMatrix dmat, Graph graph) throws IOException {
        float distr2norm;
        DenseMatrix projection = new DenseMatrix();
        for (int i = 0; i < graph.getVertex().size(); ++i) {
            float[] vect = new float[]{graph.getVertex().get(i).getX(), graph.getVertex().get(i).getY()};
            projection.addRow(new DenseVector(vect));
        }
        DistanceMatrix dmatprj = new DistanceMatrix(projection, new Euclidean());
        float num = 0.0f;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                float distrnnorm = (dmat.getDistance(i, j) - dmat.getMinDistance()) / (dmat.getMaxDistance() - dmat.getMinDistance());
                distr2norm = (dmatprj.getDistance(i, j) - dmatprj.getMinDistance()) / (dmatprj.getMaxDistance() - dmatprj.getMinDistance());
                num += (distrnnorm - distr2norm) * (distrnnorm - distr2norm);
            }
        }
        float den = 0.0f;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                distr2norm = (dmatprj.getDistance(i, j) - dmatprj.getMinDistance()) / (dmatprj.getMaxDistance() - dmatprj.getMinDistance());
                den += distr2norm * distr2norm;
            }
        }
        return num / den;
    }
}

