/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import visualizer.datamining.dataanalysis.NeighborhoodPreservation;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.OpenDialog;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.DMATFilter;
import visualizer.util.filefilter.XMLFilter;

public class NeighborhoodPreservationView
extends JDialog {
    private DefaultTableModel projTableModel;
    private JButton addButton;
    private JPanel buttonPanel;
    private JPanel chooseDistanceTypePanel2;
    private JButton closeButton;
    private JPanel dataPanel;
    private JComboBox distanceComboBox;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JButton generateButton;
    private JPanel multiDataPanel;
    private JLabel nrNeighborsLabel;
    private JPanel nrNeighborsPanel;
    private JTextField nrNeighborsTextField;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private JPanel projButtonPanel;
    private JPanel projPanel;
    private JScrollPane projScrollPane;
    private JTable projTable;
    private JButton removeButton;
    private ButtonGroup sourceButtonGroup;
    private JPanel sourcePanel;

    public NeighborhoodPreservationView(Frame parent) {
        super(parent);
        this.initComponents();
        this.initModels();
        for (DissimilarityType disstype : DissimilarityType.getTypes()) {
            if (disstype == DissimilarityType.KOLMOGOROV || disstype == DissimilarityType.NONE) continue;
            this.distanceComboBox.addItem(disstype);
        }
        this.projTable.setModel(this.projTableModel);
    }

    private void initComponents() {
        this.sourceButtonGroup = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.generateButton = new JButton();
        this.closeButton = new JButton();
        this.dataPanel = new JPanel();
        this.multiDataPanel = new JPanel();
        this.chooseDistanceTypePanel2 = new JPanel();
        this.distanceComboBox = new JComboBox();
        this.sourcePanel = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.nrNeighborsPanel = new JPanel();
        this.nrNeighborsLabel = new JLabel();
        this.nrNeighborsTextField = new JTextField();
        this.projPanel = new JPanel();
        this.projScrollPane = new JScrollPane();
        this.projTable = new JTable();
        this.projButtonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Neighborhood Preservation");
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservationView.this.generateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.generateButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservationView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new BorderLayout(5, 5));
        this.multiDataPanel.setBorder(BorderFactory.createTitledBorder("Multidimensional Data"));
        this.multiDataPanel.setLayout(new GridBagLayout());
        this.chooseDistanceTypePanel2.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel2.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.multiDataPanel.add((Component)this.chooseDistanceTypePanel2, gridBagConstraints);
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.sourceButtonGroup.add(this.pointsRadioButton);
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservationView.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.distanceMatrixRadioButton);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservationView.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservationView.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservationView.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.multiDataPanel.add((Component)this.sourcePanel, gridBagConstraints);
        this.nrNeighborsPanel.setLayout(new FlowLayout(0));
        this.nrNeighborsLabel.setText("Number of neighbors");
        this.nrNeighborsPanel.add(this.nrNeighborsLabel);
        this.nrNeighborsTextField.setColumns(10);
        this.nrNeighborsTextField.setText("30");
        this.nrNeighborsPanel.add(this.nrNeighborsTextField);
        this.multiDataPanel.add((Component)this.nrNeighborsPanel, new GridBagConstraints());
        this.dataPanel.add((Component)this.multiDataPanel, "South");
        this.projPanel.setBorder(BorderFactory.createTitledBorder("Projections"));
        this.projPanel.setLayout(new BorderLayout());
        this.projScrollPane.setPreferredSize(new Dimension(452, 250));
        this.projScrollPane.setViewportView(this.projTable);
        this.projPanel.add((Component)this.projScrollPane, "Center");
        this.projButtonPanel.setLayout(new GridBagLayout());
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservationView.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projButtonPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservationView.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projButtonPanel.add((Component)this.removeButton, gridBagConstraints);
        this.projPanel.add((Component)this.projButtonPanel, "After");
        this.dataPanel.add((Component)this.projPanel, "Center");
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.pack();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        if (this.projTable.getRowCount() > 0) {
            ArrayList<NeighborhoodPreservation.Serie> series = new ArrayList<NeighborhoodPreservation.Serie>();
            for (int i = 0; i < this.projTable.getRowCount(); ++i) {
                String filename = (String)this.projTable.getValueAt(i, 1);
                if (filename.trim().length() <= 0) continue;
                String description = (String)this.projTable.getValueAt(i, 0);
                NeighborhoodPreservation.Serie serie = new NeighborhoodPreservation.Serie(description, filename);
                series.add(serie);
            }
            if (this.pointsRadioButton.isSelected()) {
                if (this.pointsTextField.getText().trim().length() > 0) {
                    try {
                        Matrix matrix = MatrixFactory.getInstance(this.pointsTextField.getText());
                        DissimilarityType mtype = (DissimilarityType)this.distanceComboBox.getSelectedItem();
                        Dissimilarity diss = DissimilarityFactory.getInstance(mtype);
                        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
                        NeighborhoodPreservation.getInstance(this).display(dmat, series, Integer.parseInt(this.nrNeighborsTextField.getText()));
                    }
                    catch (IOException ex) {
                        Logger.getLogger(NeighborhoodPreservationView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "A points file must be selected.", "Error", 0);
                }
            } else if (this.distanceMatrixRadioButton.isSelected()) {
                if (this.distanceMatrixTextField.getText().trim().length() > 0) {
                    try {
                        DistanceMatrix dmat = new DistanceMatrix(this.distanceMatrixTextField.getText());
                        NeighborhoodPreservation.getInstance(this).display(dmat, series, Integer.parseInt(this.nrNeighborsTextField.getText()));
                    }
                    catch (IOException ex) {
                        Logger.getLogger(NeighborhoodPreservationView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "A distance matrix file must be selected.", "Error", 0);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "At least one projection must be added.", "Error", 0);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new XMLFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            String description = filename.substring(filename.lastIndexOf("\\") + 1, filename.lastIndexOf("."));
            this.projTableModel.addRow(new String[]{description, filename});
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.projTable.getSelectedRow();
        if (index > -1) {
            this.projTableModel.removeRow(index);
        }
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.distanceComboBox.setEnabled(true);
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.distanceComboBox.setEnabled(false);
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.pointsTextField.setText(filename);
        }
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DMATFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.distanceMatrixTextField.setText(filename);
        }
    }

    public static NeighborhoodPreservationView getInstance(JFrame parent) {
        return new NeighborhoodPreservationView(parent);
    }

    public void display() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void initModels() {
        Object[] titles = new String[]{"Description", "File name"};
        this.projTableModel = new DefaultTableModel((Object[][])null, titles);
    }
}

