/*
 * Decompiled with CFR 0.152.
 */
package visualizer.dimensionreduction;

import java.util.ArrayList;

public class DimensionalityReductionType {
    public static final DimensionalityReductionType NONE;
    public static final DimensionalityReductionType PCA;
    public static final DimensionalityReductionType FASTMAP;
    public static final DimensionalityReductionType KMEANS;
    private static ArrayList<DimensionalityReductionType> types;
    private String name;

    private DimensionalityReductionType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<DimensionalityReductionType> getTypes() {
        return types;
    }

    public static DimensionalityReductionType retrieve(String name) {
        for (DimensionalityReductionType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionalityReductionType other = (DimensionalityReductionType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        NONE = new DimensionalityReductionType("None");
        PCA = new DimensionalityReductionType("PCA");
        FASTMAP = new DimensionalityReductionType("Fastmap");
        KMEANS = new DimensionalityReductionType("K-means");
    }
}

