/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureselection;

public class PointsSelection {
    private float[][] points;
    private String[] attributes;
    private int[] attributeStatus;

    PointsSelection(float[][] points, String[] attributes) {
        this.points = points;
        this.attributes = attributes;
        this.attributeStatus = new int[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            this.attributeStatus[i] = 0;
        }
        this.attributeStatus[attributes.length - 1] = 1;
    }

    private int searchAttribute(String attribute) {
        int i = 0;
        while (!this.attributes[i].equals(attribute)) {
            ++i;
        }
        if (i < this.attributes.length) {
            return i;
        }
        return -1;
    }

    public void selectAttribute(String attribute) {
        this.attributeStatus[this.searchAttribute((String)attribute)] = 1;
    }

    public void discardAttribute(String attribute) {
        this.attributeStatus[this.searchAttribute((String)attribute)] = 0;
    }

    public String[] getSelectedAttributes() {
        String[] sAttributes = new String[this.numberOfSelectedAttributes()];
        int j = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributeStatus[i] != 1) continue;
            sAttributes[j] = this.attributes[i];
            ++j;
        }
        return sAttributes;
    }

    public String[] getDiscardedAttributes() {
        String[] dAttributes = new String[this.numberOfDiscardedAttributes()];
        int j = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributeStatus[i] != 0) continue;
            dAttributes[j] = this.attributes[i];
            ++j;
        }
        return dAttributes;
    }

    public String[] getAttributes() {
        String[] Attributes2 = new String[this.numberOfAttributes()];
        int j = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributeStatus[i] != 0) continue;
            Attributes2[j] = this.attributes[i];
            ++j;
        }
        return Attributes2;
    }

    public float[][] getSelectedPoints() {
        int np = this.points.length;
        int ns = this.numberOfSelectedAttributes();
        int na = this.attributes.length;
        float[][] sPoints = new float[np][ns];
        for (int i = 0; i < np; ++i) {
            int k = 0;
            for (int j = 0; j < na; ++j) {
                if (this.attributeStatus[j] != 1) continue;
                sPoints[i][k] = this.points[i][j];
                ++k;
            }
        }
        return sPoints;
    }

    public void savePointsToFile(String filename, String separator) {
    }

    public void saveSelectedPointsToFile(String filename, String separator) {
        float[][] sPoints = this.getSelectedPoints();
    }

    public int numberOfSelectedAttributes() {
        int sum = 0;
        for (int i = 0; i < this.attributeStatus.length; ++i) {
            if (this.attributeStatus[i] != 1) continue;
            ++sum;
        }
        return sum;
    }

    public int numberOfDiscardedAttributes() {
        int sum = 0;
        for (int i = 0; i < this.attributeStatus.length; ++i) {
            if (this.attributeStatus[i] != 0) continue;
            ++sum;
        }
        return sum;
    }

    public int numberOfAttributes() {
        return this.attributeStatus.length;
    }
}

