/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import visualizer.forcelayout.ForceSimulator;
import visualizer.forcelayout.Spring;
import visualizer.graph.Vertex;

public abstract class Force {
    private float[] params;

    public abstract void init(ForceSimulator var1);

    public int getParameterCount() {
        return this.params == null ? 0 : this.params.length;
    }

    public float getParameter(int i) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[i];
    }

    public String getParameterName(int i) {
        String[] pnames = this.getParameterNames();
        if (i < 0 || pnames == null || i >= pnames.length) {
            throw new IndexOutOfBoundsException();
        }
        return pnames[i];
    }

    public void setParameter(int i, float val) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.params[i] = val;
    }

    public abstract String[] getParameterNames();

    public boolean isSpringForce() {
        return false;
    }

    public boolean isItemForce() {
        return false;
    }

    public void getForce(Vertex vertex) {
    }

    public void getForce(Spring spring) {
    }
}

