/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.graph.Connectivity;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.view.Viewer;

public class ForceDirectLayout
implements Runnable {
    private static final float MAX_EDGE_SIZE = 20.0f;
    private static final float MIN_EDGE_SIZE = 5.0f;
    private boolean normalize = true;
    private float max_length;
    private float min_length;
    private ArrayList<Edge> edges;
    private ArrayList<Vertex> vertex;
    private Graph graph;
    private Viewer gv;
    private Thread relaxer;

    public ForceDirectLayout(Graph graph, Viewer gv) {
        this.graph = graph;
        this.gv = gv;
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        int i = 0;
        while (this.relaxer == me) {
            this.relax();
            if (i++ % 5 != 0) continue;
            try {
                this.gv.updateImage();
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    synchronized void relax() {
        if (this.edges != null && this.vertex != null) {
            int i;
            for (i = 0; i < this.edges.size(); ++i) {
                Edge e = this.edges.get(i);
                float vx = e.getTarget().getX() - e.getSource().getX();
                float vy = e.getTarget().getY() - e.getSource().getY();
                float len = (float)Math.sqrt(vx * vx + vy * vy);
                float edgeLen = e.getLength();
                edgeLen = edgeLen != -1.0f && this.normalize ? (edgeLen - this.min_length) / (this.max_length - this.min_length) * 15.0f + 5.0f : 20.0f;
                len = len == 0.0f ? 1.0E-4f : len;
                float f = (edgeLen - len) / (len * 3.0f);
                float dx = f * vx;
                float dy = f * vy;
                e.getTarget().fdata.dx += dx;
                e.getTarget().fdata.dy += dy;
                e.getSource().fdata.dx += -dx;
                e.getSource().fdata.dy += -dy;
            }
            for (i = 0; i < this.vertex.size(); ++i) {
                Vertex v1 = this.vertex.get(i);
                float dx = 0.0f;
                float dy = 0.0f;
                for (int j = 0; j < this.vertex.size(); ++j) {
                    float vy;
                    if (i == j) continue;
                    Vertex v2 = this.vertex.get(j);
                    float vx = v1.getX() - v2.getX();
                    float len = vx * vx + (vy = v1.getY() - v2.getY()) * vy;
                    if (len == 0.0f) {
                        dx = (float)((double)dx + Math.random());
                        dy = (float)((double)dy + Math.random());
                        continue;
                    }
                    if (!(len < 10000.0f)) continue;
                    dx += vx / len;
                    dy += vy / len;
                }
                float dlen = dx * dx + dy * dy;
                if (!(dlen > 0.0f)) continue;
                dlen = (float)Math.sqrt(dlen) / 2.0f;
                v1.fdata.dx += dx / dlen;
                v1.fdata.dy += dy / dlen;
            }
            for (i = 0; i < this.vertex.size(); ++i) {
                Vertex v = this.vertex.get(i);
                float x = v.getX() + Math.max(-5.0f, Math.min(5.0f, v.fdata.dx));
                float y = v.getY() + Math.max(-5.0f, Math.min(5.0f, v.fdata.dy));
                v.setX(x);
                v.setY(y);
                v.fdata.dx /= 2.0f;
                v.fdata.dy /= 2.0f;
            }
        }
    }

    public void start(Connectivity connectivity) {
        if (connectivity != null) {
            this.edges = connectivity.getEdges();
            this.vertex = this.graph.getVertex();
            this.max_length = Float.MIN_VALUE;
            this.min_length = Float.MAX_VALUE;
            for (Edge e : this.edges) {
                if (e.getLength() > this.max_length) {
                    this.max_length = e.getLength();
                }
                if (!(e.getLength() < this.min_length)) continue;
                this.min_length = e.getLength();
            }
            this.normalize = this.max_length > this.min_length;
            this.relaxer = new Thread(this);
            this.relaxer.start();
        }
    }

    public void stop() {
        this.relaxer = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.graph.normalizeVertex(this.graph.getVertex().get(0).getRayBase() * 5 + 10, (float)d.getHeight() / 1.65f);
        this.gv.updateImage();
    }
}

