/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import visualizer.forcelayout.DragForce;
import visualizer.forcelayout.ForceSimulator;
import visualizer.forcelayout.NBodyForce;
import visualizer.forcelayout.SpringForce;
import visualizer.graph.Connectivity;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.view.Viewer;

public class ForceLayout
implements Runnable {
    public static final float MASS = 1.0f;
    public static final float LENGTH = 1.0f;
    public static final float COEF = -1.0f;
    private Graph graph;
    private ArrayList<Edge> edges;
    private ArrayList<Vertex> vertices;
    private Viewer gv;
    private Thread relaxer;
    private ForceSimulator fsim;

    public ForceLayout(Graph graph, Viewer gv) {
        this.graph = graph;
        this.vertices = graph.getVertex();
        this.gv = gv;
        this.fsim = new ForceSimulator();
        this.fsim.addForce(new NBodyForce(-0.4f, -1.0f, 0.9f));
        this.fsim.addForce(new SpringForce(1.0E-4f, 75.0f));
        this.fsim.addForce(new DragForce(-0.005f));
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        int i = 0;
        while (this.relaxer == me) {
            this.relax();
            if (i++ % 5 != 0) continue;
            this.gv.updateImage();
        }
    }

    synchronized void relax() {
        this.fsim.runSimulator(15L);
        this.updateLocation();
        this.gv.updateImage();
    }

    public void start(Connectivity connectivity) {
        this.edges = connectivity.getEdges();
        for (Vertex v : this.vertices) {
            v.fdata.mass = 1.0f;
            v.fdata.location[0] = v.getX();
            v.fdata.location[1] = v.getY();
            this.fsim.addItem(v);
        }
        for (Edge e : this.edges) {
            Vertex v1 = e.getSource();
            Vertex v2 = e.getTarget();
            float coeff = -1.0f;
            float slen = 1.0f;
            this.fsim.addSpring(v1, v2, coeff >= 0.0f ? coeff : -1.0f, slen >= 0.0f ? slen : -1.0f);
        }
        this.relaxer = new Thread(this);
        this.relaxer.start();
    }

    public void updateLocation() {
        for (Vertex v : this.vertices) {
            v.setX(v.fdata.location[0]);
            v.setY(v.fdata.location[1]);
        }
    }

    public void stop() {
        this.relaxer.interrupt();
        this.relaxer = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.graph.normalizeVertex(this.graph.getVertex().get(0).getRayBase() * 5 + 10, (float)d.getHeight() / 1.65f);
        this.gv.updateImage();
    }
}

