/*
 * Decompiled with CFR 0.152.
 */
package visualizer.google;

import java.util.Calendar;
import java.util.GregorianCalendar;
import visualizer.google.GoogleGetter;
import visualizer.google.GoogleSearchManager;
import visualizer.google.GoogleView;

public class GoogleSearch {
    private GoogleView googleView;
    private Thread t;
    private String searchKey;
    private String query;
    private int numberRequestedDocs;
    private int numberFetchedDocs;

    public GoogleSearch(String searchKey, GoogleView googleView) {
        this.googleView = googleView;
        this.searchKey = searchKey;
    }

    public void search(final String query, int numberDocuments) {
        this.numberRequestedDocs = numberDocuments;
        this.query = query;
        this.t = new Thread(){

            @Override
            public void run() {
                String googleCorpus = "google/google_" + Calendar.getInstance().getTimeInMillis() + ".zip";
                GoogleGetter getter = new GoogleGetter(GoogleSearch.this);
                getter.search(query, GoogleSearch.this.searchKey, GoogleSearch.this.numberRequestedDocs / 10, googleCorpus);
                Calendar calendar = GregorianCalendar.getInstance();
                int day = calendar.get(5);
                int month = calendar.get(2) + 1;
                int year = calendar.get(1);
                int hour = calendar.get(11);
                int minute = calendar.get(12);
                int second = calendar.get(13);
                int millisecond = calendar.get(14);
                String queryId = query + " [" + day + "/" + month + "/" + year + " - " + hour + ":" + minute + ":" + second + ":" + millisecond + "]";
                GoogleSearch.this.query = queryId;
                GoogleSearchManager manager = GoogleSearchManager.getInstance();
                manager.newQuery(queryId, googleCorpus);
                GoogleSearch.this.googleView.queryFinished(GoogleSearch.this);
            }
        };
        this.t.start();
    }

    public void stopSearch() {
        if (this.t != null && this.t.isAlive()) {
            this.t.interrupt();
            this.googleView.removeQuery(this);
        }
    }

    public int getNumberRequestedDocuments() {
        return this.numberRequestedDocs;
    }

    public int getNumberFetchedDocuments() {
        return this.numberFetchedDocs;
    }

    public void setNumberFetchedDocuments(int numberDocuments) {
        this.numberFetchedDocs = numberDocuments;
        this.googleView.updateTable();
    }

    public String getQuery() {
        return this.query;
    }
}

