/*
 * Decompiled with CFR 0.152.
 */
package visualizer.google;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import visualizer.google.GoogleSearch;

public class GoogleSearchTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] colunmNames;
    private ArrayList<GoogleSearch> searches = new ArrayList();

    public GoogleSearchTableModel(String[] colunmNames) {
        this.colunmNames = colunmNames;
    }

    public GoogleSearchTableModel() {
        this.colunmNames = new String[]{"Queries", "Request Documents", "Fetched Documents"};
    }

    @Override
    public String getColumnName(int column) {
        return this.colunmNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        GoogleSearch gsearch = this.searches.get(rowIndex);
        if (columnIndex == 0) {
            return gsearch.getQuery();
        }
        if (columnIndex == 1) {
            return Integer.toString(gsearch.getNumberRequestedDocuments());
        }
        if (columnIndex == 2) {
            return Integer.toString(gsearch.getNumberFetchedDocuments());
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.searches.size();
    }

    @Override
    public int getColumnCount() {
        return this.colunmNames.length;
    }

    public void addRow(GoogleSearch gsearch) {
        this.searches.add(gsearch);
        this.fireTableRowsInserted(0, this.searches.size());
    }

    public void removeRow(int index) {
        this.searches.remove(index);
        this.fireTableRowsDeleted(0, this.searches.size());
    }

    public void update() {
        this.fireTableRowsUpdated(0, this.searches.size());
    }
}

