/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import visualizer.corpus.Corpus;
import visualizer.datamining.clustering.HierarchicalClustering;
import visualizer.datamining.clustering.HierarchicalClusteringType;
import visualizer.graph.Connectivity;
import visualizer.graph.Edge;
import visualizer.graph.ImageCollection;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.graph.scalar.QuerySolver;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.Euclidean;
import visualizer.topic.TopicData;

public class Graph
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Corpus corpus;
    protected ImageCollection imageCollection;
    protected TopicData tdata = new TopicData(this);
    protected boolean isEdgeVisible = true;
    protected ProjectionData pData = new ProjectionData();
    protected ArrayList<Scalar> scalars = new ArrayList();
    protected ArrayList<String> titles = new ArrayList();
    protected String description = "";
    protected ArrayList<Vertex> vertex = new ArrayList();
    protected ArrayList<Connectivity> connectivities = new ArrayList();

    public Dimension getSize() {
        if (this.vertex.size() > 0) {
            float maxX = this.vertex.get(0).getX();
            float minX = this.vertex.get(0).getX();
            float maxY = this.vertex.get(0).getY();
            float minY = this.vertex.get(0).getY();
            for (Vertex v : this.vertex) {
                if (maxX < v.getX()) {
                    maxX = v.getX();
                } else if (minX > v.getX()) {
                    minX = v.getX();
                }
                if (maxY < v.getY()) {
                    maxY = v.getY();
                    continue;
                }
                if (!(minY > v.getY())) continue;
                minY = v.getY();
            }
            int w = (int)(maxX + (float)(this.vertex.get(0).getRayBase() * 5)) + 350;
            int h = (int)(maxY + (float)(this.vertex.get(0).getRayBase() * 5));
            return new Dimension(w, h);
        }
        return new Dimension(0, 0);
    }

    public Vertex getVertexByPosition(int x, int y) {
        for (Vertex v : this.vertex) {
            if (!v.isInside(x, y)) continue;
            return v;
        }
        return null;
    }

    public void draw(Connectivity connectivity, Graphics2D g2) {
        boolean globalsel = false;
        for (Vertex v : this.vertex) {
            if (!v.isSelected()) continue;
            globalsel = true;
        }
        if (connectivity != null && connectivity != null) {
            ArrayList<Edge> edges = connectivity.getEdges();
            if (this.isEdgeVisible) {
                for (Edge edge : edges) {
                    edge.draw(g2, globalsel);
                }
            }
        }
        for (Vertex v : this.vertex) {
            if (v.isValid()) continue;
            v.draw(g2, false);
        }
        for (Vertex v : this.vertex) {
            if (!v.isValid() || v.isSelected()) continue;
            v.draw(g2, globalsel);
        }
        for (Vertex v : this.vertex) {
            if (!v.isValid() || !v.isSelected()) continue;
            v.draw(g2, globalsel);
        }
    }

    public ArrayList<Vertex> getVertex() {
        return this.vertex;
    }

    public void setVertex(ArrayList<Vertex> vertex) {
        this.vertex = vertex;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.normalizeVertex(this.vertex.get(0).getRayBase() * 5 + 10, (float)d.getHeight() / 1.65f);
    }

    public void getNeighbors(ArrayList<Vertex> neighborsVertex, ArrayList<Edge> neighborsEdges, Connectivity connectivity, Vertex vertex, int depth) {
        if (connectivity != null) {
            ArrayList<Edge> edges = connectivity.getEdges();
            ArrayList<Vertex> visitedVertex = new ArrayList<Vertex>();
            ArrayList<Vertex> vertexToVisit = new ArrayList<Vertex>();
            vertexToVisit.add(vertex);
            for (int i = 0; i < depth; ++i) {
                for (int j = 0; j < vertexToVisit.size(); ++j) {
                    Vertex v = (Vertex)vertexToVisit.get(j);
                    for (Edge e : edges) {
                        if (e.getSource().getId() == v.getId() && !neighborsVertex.contains(e.getTarget())) {
                            neighborsVertex.add(e.getTarget());
                            visitedVertex.add(e.getTarget());
                            if (neighborsEdges != null && !neighborsEdges.contains(e)) {
                                neighborsEdges.add(e);
                            }
                        }
                        if (e.getTarget().getId() != v.getId() || neighborsVertex.contains(e.getSource())) continue;
                        neighborsVertex.add(e.getSource());
                        visitedVertex.add(e.getSource());
                        if (neighborsEdges == null || neighborsEdges.contains(e)) continue;
                        neighborsEdges.add(e);
                    }
                }
                vertexToVisit = visitedVertex;
                visitedVertex = new ArrayList();
            }
            neighborsVertex.remove(vertex);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Scalar createQueryScalar(String word) throws IOException {
        if (this.corpus == null) {
            throw new IOException("The corpus must be loaded!");
        }
        String scalarName = "'" + word + "'";
        Scalar scalar = this.addScalar(scalarName);
        QuerySolver qS = new QuerySolver(this.corpus, this.vertex);
        qS.createCdata(word, scalar);
        return scalar;
    }

    public ArrayList<Connectivity> getConnectivities() {
        return this.connectivities;
    }

    public Connectivity getConnectivityByName(String name) {
        for (Connectivity c : this.connectivities) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public void addConnectivity(Connectivity connectivity) {
        this.removeConnectivity(connectivity);
        this.connectivities.add(connectivity);
    }

    public void removeConnectivity(Connectivity connectivity) {
        this.connectivities.remove(connectivity);
    }

    public void normalizeVertex(float begin, float end) {
        float maxX = this.vertex.get(0).getX();
        float minX = this.vertex.get(0).getX();
        float maxY = this.vertex.get(0).getY();
        float minY = this.vertex.get(0).getY();
        for (Vertex v : this.vertex) {
            if (maxX < v.getX()) {
                maxX = v.getX();
            } else if (minX > v.getX()) {
                minX = v.getX();
            }
            if (maxY < v.getY()) {
                maxY = v.getY();
                continue;
            }
            if (!(minY > v.getY())) continue;
            minY = v.getY();
        }
        float endX = (maxX - minX) * end;
        if (maxY != minY) {
            endX = (maxX - minX) * end / (maxY - minY);
        }
        for (Vertex v : this.vertex) {
            if (maxX != minX) {
                v.setX((v.getX() - minX) / (maxX - minX) * (endX - begin) + begin);
            } else {
                v.setX(begin);
            }
            if (maxY != minY) {
                v.setY((v.getY() - minY) / (maxY - minY) * (end - begin) + begin);
                continue;
            }
            v.setY(begin);
        }
    }

    public Scalar addScalar(String name) {
        Scalar scalar = new Scalar(name);
        if (!this.scalars.contains(scalar)) {
            this.scalars.add(scalar);
        }
        scalar.setIndex(this.scalars.indexOf(scalar));
        return this.scalars.get(scalar.getIndex());
    }

    public ArrayList<Scalar> getScalars() {
        return this.scalars;
    }

    public Scalar getScalarByName(String name) {
        for (Scalar s : this.scalars) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public void removeScalar(Scalar scalar) {
        for (Vertex v : this.vertex) {
            v.removeScalar(scalar);
        }
        this.scalars.remove(scalar);
        for (int i = 0; i < this.scalars.size(); ++i) {
            this.scalars.get(i).setIndex(i);
        }
    }

    public int getTitleIndex(String name) {
        return this.titles.indexOf(name);
    }

    public int addTitle(String name) {
        if (!this.titles.contains(name)) {
            this.titles.add(name);
        }
        return this.titles.indexOf(name);
    }

    public ArrayList<String> getTitles() {
        return this.titles;
    }

    public void removeTitle(String title) {
        int index = this.titles.indexOf(title);
        this.titles.remove(title);
        for (Vertex v : this.vertex) {
            v.removeTile(index);
        }
    }

    public void changeTitle(String title) {
        int index = this.getTitleIndex(title);
        for (Vertex v : this.getVertex()) {
            v.changeTitle(index);
        }
    }

    public ProjectionData getProjectionData() {
        return this.pData;
    }

    public Scalar createHC(HierarchicalClusteringType type) throws IOException {
        float[][] projection = new float[this.getVertex().size()][];
        for (int i = 0; i < this.getVertex().size(); ++i) {
            projection[i] = new float[2];
            projection[i][0] = this.getVertex().get(i).getX();
            projection[i][1] = this.getVertex().get(i).getY();
        }
        DenseMatrix dproj = new DenseMatrix();
        for (int i = 0; i < projection.length; ++i) {
            dproj.addRow(new DenseVector(projection[i]));
        }
        HierarchicalClustering hc = new HierarchicalClustering(type);
        float[] hcScalars = hc.getPointsHeight(dproj, new Euclidean());
        String scalarname = "hc-slink";
        if (type == HierarchicalClusteringType.ALINK) {
            scalarname = "hc-alink";
        } else if (type == HierarchicalClusteringType.CLINK) {
            scalarname = "hc-clink";
        }
        Scalar scalar = this.addScalar(scalarname);
        for (int i = 0; i < this.getVertex().size(); ++i) {
            this.getVertex().get(i).setScalar(scalar, hcScalars[i]);
        }
        return scalar;
    }

    public void exportCorpus(String newCorpusName, Scalar scalar, boolean reverse) {
        if (this.corpus != null) {
            ArrayList<Vertex> newvertex = new ArrayList<Vertex>();
            for (Vertex v : this.vertex) {
                if (!(scalar == null || scalar.getIndex() == -1 || reverse && v.getNormalizedScalar(scalar) <= 0.1f) && (reverse || !(v.getNormalizedScalar(scalar) >= 0.1f))) continue;
                newvertex.add(v);
            }
            this.exportCorpus(newCorpusName, newvertex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCorpus(String newCorpusName, ArrayList<Vertex> vertex) {
        if (this.corpus != null) {
            DeflaterOutputStream zout = null;
            try {
                FileOutputStream dest = new FileOutputStream(newCorpusName);
                zout = new ZipOutputStream(new BufferedOutputStream(dest));
                ((ZipOutputStream)zout).setMethod(8);
                for (Vertex v : vertex) {
                    if (v.getUrl() == null) continue;
                    ZipEntry entry = new ZipEntry(v.getUrl());
                    ((ZipOutputStream)zout).putNextEntry(entry);
                    String filecontent = this.corpus.getFullContent(v.getUrl());
                    ((ZipOutputStream)zout).write(filecontent.getBytes(), 0, filecontent.length());
                }
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (zout != null) {
                    try {
                        zout.flush();
                        ((ZipOutputStream)zout).finish();
                        ((ZipOutputStream)zout).close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Graph.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public void removeVertex(ArrayList<Vertex> vertex) {
        int i;
        for (i = 0; i < vertex.size(); ++i) {
            Vertex v = vertex.get(i);
            this.vertex.remove(v);
            for (Connectivity con : this.connectivities) {
                ArrayList<Edge> edges;
                if (con == null || (edges = con.getEdges()) == null) continue;
                for (int j = 0; j < edges.size(); ++j) {
                    if (edges.get(j).getSource() != v && edges.get(j).getTarget() != v) continue;
                    con.getEdges().remove(j);
                    --j;
                }
            }
        }
        for (i = 0; i < this.vertex.size(); ++i) {
            this.vertex.get(i).setId(i);
        }
    }

    public Graph cutGraph(ArrayList<Vertex> vertex) {
        try {
            HashMap<Vertex, Vertex> vertexMap = new HashMap<Vertex, Vertex>();
            ArrayList<Vertex> newVertex = new ArrayList<Vertex>();
            Graph graph = new Graph();
            graph.corpus = this.corpus;
            graph.pData = (ProjectionData)this.pData.clone();
            for (Scalar s : this.getScalars()) {
                graph.addScalar(s.getName());
            }
            for (String t : this.getTitles()) {
                graph.addTitle(t);
            }
            int nrValidVertex = 0;
            for (int i = 0; i < vertex.size(); ++i) {
                Vertex v = vertex.get(i);
                Vertex newV = new Vertex(i);
                newV.setColor(new Color(v.getColor().getRGB()));
                newV.setUrl(v.getUrl());
                newV.setX(v.getX());
                newV.setY(v.getY());
                newV.setRayFactor(v.getRayFactor());
                newV.setValid(v.isValid());
                for (String t : this.titles) {
                    int index = graph.getTitleIndex(t);
                    v.changeTitle(index);
                    newV.setTitle(index, v.toString());
                }
                for (int j = 0; j < this.scalars.size(); ++j) {
                    newV.setScalar(graph.scalars.get(j), v.getScalar(graph.scalars.get(j)));
                }
                newVertex.add(newV);
                vertexMap.put(v, newV);
                if (!newV.isValid()) continue;
                ++nrValidVertex;
            }
            graph.setVertex(newVertex);
            graph.pData.setNumberObjects(nrValidVertex);
            for (Connectivity oldCon : this.connectivities) {
                ArrayList<Edge> oldEdges = oldCon.getEdges();
                Connectivity newCon = new Connectivity(oldCon.getName());
                ArrayList<Edge> newEdges = new ArrayList<Edge>();
                for (int i = 0; i < vertex.size(); ++i) {
                    Vertex v = vertex.get(i);
                    if (oldEdges == null) continue;
                    for (Edge e : oldEdges) {
                        if (e.getSource() == v && vertex.contains(e.getTarget())) {
                            newEdges.add(new Edge(e.getLength(), (Vertex)vertexMap.get(e.getSource()), (Vertex)vertexMap.get(e.getTarget())));
                        }
                        if (e.getTarget() != v || !vertex.contains(e.getSource())) continue;
                        newEdges.add(new Edge(e.getLength(), (Vertex)vertexMap.get(e.getSource()), (Vertex)vertexMap.get(e.getTarget())));
                    }
                }
                newCon.setEdges(newEdges);
                graph.addConnectivity(newCon);
            }
            return graph;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(Graph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public boolean isEdgeVisible() {
        return this.isEdgeVisible;
    }

    public void setEdgeVisible(boolean isEdgeVisible) {
        this.isEdgeVisible = isEdgeVisible;
    }

    public TopicData getTopicData() {
        return this.tdata;
    }

    public boolean isCorpus() {
        if (this.vertex.size() > 0) {
            Vertex v = this.vertex.get(0);
            return v.getUrl().endsWith("txt");
        }
        return true;
    }

    public Scalar createScalarByConnection(Connectivity connectivity) {
        HashMap<Vertex, Float> vDegree = new HashMap<Vertex, Float>();
        if (connectivity != null) {
            for (Edge e : connectivity.getEdges()) {
                Vertex source = e.getSource();
                if (!vDegree.containsKey(source)) {
                    vDegree.put(source, Float.valueOf(1.0f));
                } else {
                    vDegree.put(source, Float.valueOf(((Float)vDegree.get(source)).floatValue() + 1.0f));
                }
                Vertex target = e.getTarget();
                if (!vDegree.containsKey(target)) {
                    vDegree.put(target, Float.valueOf(1.0f));
                    continue;
                }
                vDegree.put(target, Float.valueOf(((Float)vDegree.get(target)).floatValue() + 1.0f));
            }
        }
        Scalar scalar = this.addScalar(connectivity.getName());
        for (Vertex v : vDegree.keySet()) {
            v.setScalar(scalar, ((Float)vDegree.get(v)).floatValue());
        }
        return scalar;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public ImageCollection getImageCollection() {
        return this.imageCollection;
    }

    public void setImageCollection(ImageCollection imageCollection) {
        this.imageCollection = imageCollection;
    }

    public void perturb() {
        Random rand = new Random(7L);
        float maxx = Float.NEGATIVE_INFINITY;
        float minx = Float.POSITIVE_INFINITY;
        float maxy = Float.NEGATIVE_INFINITY;
        float miny = Float.POSITIVE_INFINITY;
        for (Vertex v : this.vertex) {
            if (maxx < v.getX()) {
                maxx = v.getX();
            }
            if (minx > v.getX()) {
                minx = v.getX();
            }
            if (maxy < v.getY()) {
                maxy = v.getY();
            }
            if (!(miny > v.getY())) continue;
            miny = v.getY();
        }
        float diffx = (maxx - minx) / 1000.0f;
        float diffy = (maxy - miny) / 1000.0f;
        for (int i = 0; i < this.vertex.size(); ++i) {
            this.vertex.get(i).setX(this.vertex.get(i).getX() + diffx * rand.nextFloat());
            this.vertex.get(i).setY(this.vertex.get(i).getY() + diffy * rand.nextFloat());
        }
    }
}

