/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import visualizer.forcelayout.ForceData;
import visualizer.graph.Scalar;
import visualizer.graph.XMLGraphWriter;
import visualizer.view.color.ColorTable;

public class Vertex
implements Comparable,
Serializable {
    public static final int DRAW_AS_CIRCLES = 0;
    public static final int DRAW_AS_DOTS = 1;
    public static final int DRAW_AS_IMAGES = 2;
    private int drawAs = 0;
    private static boolean showTitle = true;
    private static boolean showImage = false;
    private static boolean showContent = false;
    private Image image;
    private static final long serialVersionUID = 1L;
    private static final float EPSILON = 1.0E-5f;
    private long id = 0L;
    private ArrayList<Float> scalars = new ArrayList();
    private ArrayList<String> titles = new ArrayList();
    private int indexTitle;
    private static boolean showLabel = false;
    private String url = "";
    private static Font font = new Font("Verdana", 1, 9);
    private Color color = Color.BLACK;
    private float x = 0.0f;
    private float y = 0.0f;
    private int rayBase = 4;
    private float rayFactor = 0.0f;
    public ForceData fdata;
    private boolean valid = true;
    private boolean selected = false;
    private static boolean showNonValid = true;

    public Vertex(long id, float x, float y) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.drawAs = 0;
    }

    public Vertex(long id) {
        this.id = id;
        this.drawAs = 0;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void draw(Graphics2D g2, boolean globalsel) {
        switch (this.drawAs) {
            case 2: {
                if (this.valid) {
                    if (this.image == null) break;
                    int w = this.image.getWidth(null);
                    int h = this.image.getHeight(null);
                    g2.drawImage(this.image, (int)this.x - w / 2, (int)this.y - h / 2, null);
                    if (!this.selected) break;
                    g2.setStroke(new BasicStroke(4.0f));
                    g2.setColor(Color.RED);
                    g2.drawRect((int)this.x - w / 2 - 2, (int)this.y - h / 2 - 2, w + 3, h + 3);
                    break;
                }
                if (!showNonValid) break;
                g2.setColor(Color.GRAY);
                g2.drawLine((int)this.x - 1, (int)this.y - 1, (int)this.x + 1, (int)this.y - 1);
                g2.drawLine((int)this.x - 1, (int)this.y, (int)this.x + 1, (int)this.y);
                g2.drawLine((int)this.x - 1, (int)this.y + 1, (int)this.x + 1, (int)this.y + 1);
                break;
            }
            case 1: {
                if (this.valid) {
                    if (!globalsel || this.selected) {
                        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    } else {
                        g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    }
                    g2.setColor(this.color);
                    g2.drawLine((int)this.x - 1, (int)this.y - 1, (int)this.x + 1, (int)this.y - 1);
                    g2.drawLine((int)this.x - 1, (int)this.y, (int)this.x + 1, (int)this.y);
                    g2.drawLine((int)this.x - 1, (int)this.y + 1, (int)this.x + 1, (int)this.y + 1);
                    g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    if (!showLabel) break;
                    g2.setFont(font);
                    FontMetrics metrics = g2.getFontMetrics(g2.getFont());
                    int width = metrics.stringWidth(this.toString().trim());
                    int height = metrics.getAscent();
                    g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
                    g2.setPaint(Color.WHITE);
                    g2.fill(new Rectangle((int)this.x + this.getRay() + 5 - 2, (int)this.y - 1 - height, width + 4, height + 4));
                    g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    g2.setColor(Color.DARK_GRAY);
                    g2.drawRect((int)this.x + this.getRay() + 5 - 2, (int)this.y - 1 - height, width + 4, height + 4);
                    g2.drawString(this.toString().trim(), (int)this.x + this.getRay() + 5, (int)this.y);
                    break;
                }
                if (!showNonValid) break;
                g2.setColor(Color.LIGHT_GRAY);
                g2.drawLine((int)this.x - 1, (int)this.y - 1, (int)this.x + 1, (int)this.y - 1);
                g2.drawLine((int)this.x - 1, (int)this.y, (int)this.x + 1, (int)this.y);
                g2.drawLine((int)this.x - 1, (int)this.y + 1, (int)this.x + 1, (int)this.y + 1);
                break;
            }
            default: {
                if (this.valid) {
                    if (!globalsel || this.selected) {
                        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    } else {
                        g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    }
                    g2.setColor(this.color);
                    g2.fillOval((int)this.x - this.getRay(), (int)this.y - this.getRay(), this.getRay() * 2, this.getRay() * 2);
                    g2.setColor(Color.BLACK);
                    g2.drawOval((int)this.x - this.getRay(), (int)this.y - this.getRay(), this.getRay() * 2, this.getRay() * 2);
                    g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    if (!showLabel) break;
                    g2.setFont(font);
                    FontMetrics metrics = g2.getFontMetrics(g2.getFont());
                    int width = metrics.stringWidth(this.toString().trim());
                    int height = metrics.getAscent();
                    g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
                    g2.setPaint(Color.WHITE);
                    g2.fill(new Rectangle((int)this.x + this.getRay() + 5 - 2, (int)this.y - 1 - height, width + 4, height + 4));
                    g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    g2.setColor(Color.DARK_GRAY);
                    g2.drawRect((int)this.x + this.getRay() + 5 - 2, (int)this.y - 1 - height, width + 4, height + 4);
                    g2.drawString(this.toString().trim(), (int)this.x + this.getRay() + 5, (int)this.y);
                    break;
                }
                if (!showNonValid) break;
                int SIZE = 2;
                g2.setColor(Color.WHITE);
                g2.fillOval((int)this.x - SIZE, (int)this.y - SIZE, SIZE * 2, SIZE * 2);
                g2.setColor(Color.GRAY);
                g2.drawOval((int)this.x - SIZE, (int)this.y - SIZE, SIZE * 2, SIZE * 2);
            }
        }
    }

    public static boolean isShowTitle() {
        return showTitle;
    }

    public static boolean isShowImage() {
        return showImage;
    }

    public static boolean isShowContent() {
        return showContent;
    }

    public static void setShowImage(boolean aShowImage) {
        showImage = aShowImage;
    }

    public static void setShowContent(boolean aShowContent) {
        showContent = aShowContent;
    }

    public static void setShowTitle(boolean aShowTitle) {
        showTitle = aShowTitle;
    }

    public static boolean isShowLabel() {
        return showLabel;
    }

    public static void setShowLabel(boolean ashowLabel) {
        showLabel = ashowLabel;
    }

    public boolean isInside(int x, int y) {
        return Math.sqrt(Math.pow((float)x - this.x, 2.0) + Math.pow((float)y - this.y, 2.0)) <= (double)this.getRay();
    }

    public boolean isInside(Rectangle rectangle) {
        return this.x >= (float)rectangle.x && this.x - (float)rectangle.x < (float)rectangle.width && this.y >= (float)rectangle.y && this.y - (float)rectangle.y < (float)rectangle.height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(Scalar scalar, ColorTable colorTable) {
        if (this.valid && colorTable != null) {
            this.color = colorTable.getColor(this.getNormalizedScalar(scalar));
        }
    }

    public int getDrawAs() {
        return this.drawAs;
    }

    public void setDrawAs(int State2) {
        this.drawAs = State2;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public int getRayBase() {
        return this.rayBase;
    }

    public void setRayBase(int aRay) {
        this.rayBase = aRay;
    }

    public void setRayFactor(float ray) {
        assert (ray >= 0.0f && ray <= 1.0f) : "Out of range ray factor.";
        this.rayFactor = ray;
    }

    public float getRayFactor() {
        return this.rayFactor;
    }

    public int getRay() {
        return (int)((float)this.rayBase + this.rayFactor * (float)this.rayBase);
    }

    public void setRayFactor(Scalar scalar) {
        if (this.valid) {
            this.rayFactor = this.getNormalizedScalar(scalar);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = XMLGraphWriter.deConvert(url);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        if (this.titles.size() > this.indexTitle) {
            return this.titles.get(this.indexTitle);
        }
        return Long.toString(this.id);
    }

    public void changeTitle(int index) {
        this.indexTitle = index;
    }

    public void setTitle(int index, String title) {
        if ((title = XMLGraphWriter.deConvert(title)).length() > 100) {
            title = title.substring(0, 96) + "...";
        }
        if (this.titles.size() > index) {
            this.titles.set(index, title);
        } else {
            int size = this.titles.size();
            for (int i = 0; i < index - size; ++i) {
                this.titles.add("");
            }
            this.titles.add(title);
        }
    }

    public void removeTile(int index) {
        if (this.titles.size() > index) {
            this.titles.remove(index);
        }
        if (this.indexTitle == index) {
            this.indexTitle = 0;
        }
    }

    public void setScalar(Scalar scalar, float value) {
        assert (scalar.getIndex() >= 0) : "Error scalar created outside the method Graph.addScalar(...).";
        if (scalar != null) {
            if (this.scalars.size() > scalar.getIndex()) {
                this.scalars.set(scalar.getIndex(), Float.valueOf(value));
            } else {
                int size = this.scalars.size();
                for (int i = 0; i < scalar.getIndex() - size; ++i) {
                    this.scalars.add(Float.valueOf(0.0f));
                }
                this.scalars.add(Float.valueOf(value));
            }
            if (scalar.getMin() > value) {
                scalar.setMin(value);
            }
            if (scalar.getMax() < value) {
                scalar.setMax(value);
            }
        }
    }

    public float getScalar(Scalar scalar) {
        if (scalar != null && this.scalars.size() > scalar.getIndex() && scalar.getIndex() > -1) {
            return this.scalars.get(scalar.getIndex()).floatValue();
        }
        return 0.0f;
    }

    public float getNormalizedScalar(Scalar scalar) {
        if (scalar != null && this.scalars.size() > scalar.getIndex() && scalar.getIndex() > -1) {
            if (scalar.getMax() > scalar.getMin()) {
                float value = this.scalars.get(scalar.getIndex()).floatValue();
                return (value - scalar.getMin()) / (scalar.getMax() - scalar.getMin());
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public void removeScalar(Scalar scalar) {
        if (scalar != null && this.scalars.size() > scalar.getIndex()) {
            this.scalars.remove(scalar.getIndex());
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public static boolean isShowNonValid() {
        return showNonValid;
    }

    public static void setShowNonValid(boolean aShowNonValid) {
        showNonValid = aShowNonValid;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isDrawAsCircles() {
        switch (this.drawAs) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public boolean isDrawAsImages() {
        switch (this.drawAs) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isDrawAsDots() {
        switch (this.drawAs) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static Font getFont() {
        return font;
    }

    public static void setFont(Font aFont) {
        font = aFont;
    }

    public int compareTo(Object o) {
        if (o instanceof Vertex) {
            if (Math.abs(this.x - ((Vertex)o).x) == 1.0E-5f) {
                if (Math.abs(this.y - ((Vertex)o).y) == 1.0E-5f) {
                    return 0;
                }
                if (Math.abs(this.y - ((Vertex)o).y) > 1.0E-5f) {
                    return 1;
                }
                return -1;
            }
            if (Math.abs(this.x - ((Vertex)o).x) > 1.0E-5f) {
                return 1;
            }
            return -1;
        }
        return -1;
    }
}

