/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.coodination;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visualizer.corpus.Corpus;
import visualizer.corpus.CorpusFactory;
import visualizer.matrix.Matrix;
import visualizer.projection.ProjectionData;
import visualizer.textprocessing.Preprocessor;
import visualizer.textprocessing.stemmer.StemmerType;
import visualizer.textprocessing.transformation.MatrixTransformationType;
import visualizer.view.Viewer;

public class CorpusParametersDistanceMapping
extends JDialog {
    private Viewer graph;
    private Matrix matrix;
    private Vector<String> attributes;
    private String fileName;
    private JPanel buttonPanel;
    private ButtonGroup distanceButtonGroup;
    private JComboBox gramsComboBox;
    private JLabel gramsLabel;
    private JLabel luhnLabel;
    private JTextField luhnLowerTextField;
    private JLabel luhnUpperLabel;
    private JTextField luhnUpperTextField;
    private JPanel matrixTypePanel;
    private JComboBox matrixtransfComboBox;
    private JButton okButton;
    private JPanel preProcessingPanel;
    private JPanel projPanel;
    private JComboBox stemmerComboBox;

    private CorpusParametersDistanceMapping(Dialog parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        for (StemmerType st : StemmerType.getTypes()) {
            this.stemmerComboBox.addItem(st);
        }
        for (MatrixTransformationType mtt : MatrixTransformationType.getTypes()) {
            this.matrixtransfComboBox.addItem(mtt);
        }
    }

    private void initComponents() {
        this.distanceButtonGroup = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.projPanel = new JPanel();
        this.preProcessingPanel = new JPanel();
        this.luhnLabel = new JLabel();
        this.gramsComboBox = new JComboBox();
        this.gramsLabel = new JLabel();
        this.luhnLowerTextField = new JTextField();
        this.luhnUpperLabel = new JLabel();
        this.luhnUpperTextField = new JTextField();
        this.stemmerComboBox = new JComboBox();
        this.matrixTypePanel = new JPanel();
        this.matrixtransfComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Mapping Parameters");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorpusParametersDistanceMapping.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.projPanel.setBorder(BorderFactory.createTitledBorder("Projection"));
        this.projPanel.setLayout(new GridBagLayout());
        this.preProcessingPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.preProcessingPanel.setLayout(new GridBagLayout());
        this.luhnLabel.setText("Luhn's lower cut");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnLabel, gridBagConstraints);
        this.gramsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.gramsComboBox, gridBagConstraints);
        this.gramsLabel.setText("Number of grams");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.gramsLabel, gridBagConstraints);
        this.luhnLowerTextField.setColumns(5);
        this.luhnLowerTextField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnLowerTextField, gridBagConstraints);
        this.luhnUpperLabel.setText("Luhn's upper cut");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnUpperLabel, gridBagConstraints);
        this.luhnUpperTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnUpperTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.stemmerComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.projPanel.add((Component)this.preProcessingPanel, gridBagConstraints);
        this.matrixTypePanel.setBorder(BorderFactory.createTitledBorder("Matrix Transformation"));
        this.matrixTypePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.matrixTypePanel.add((Component)this.matrixtransfComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.projPanel.add((Component)this.matrixTypePanel, gridBagConstraints);
        this.getContentPane().add((Component)this.projPanel, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            ProjectionData pData = (ProjectionData)this.graph.getGraph().getProjectionData().clone();
            this.refreshData(pData);
            Corpus cp = CorpusFactory.getInstance(this.fileName, pData);
            Preprocessor pp = new Preprocessor(cp);
            this.matrix = pp.getMatrix(pData.getLunhLowerCut(), pData.getLunhUpperCut(), pData.getNumberGrams(), pData.getStemmer(), pData.isUseStopword());
            this.setVisible(false);
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CorpusParametersDistanceMapping.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static CorpusParametersDistanceMapping getInstance(JDialog parent) {
        return new CorpusParametersDistanceMapping(parent);
    }

    public void display(Viewer graph, String fileName) {
        this.graph = graph;
        this.fileName = fileName;
        this.setData(graph.getGraph().getProjectionData());
        this.projPanel.setBorder(BorderFactory.createTitledBorder("Projection [" + graph.getId() + "]"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void setData(ProjectionData pData) {
        this.stemmerComboBox.setSelectedItem(pData.getStemmer());
        this.luhnLowerTextField.setText(Integer.toString(pData.getLunhLowerCut()));
        this.matrixtransfComboBox.setSelectedItem(pData.getMatrixTransformationType());
        this.gramsComboBox.setSelectedIndex(pData.getNumberGrams() - 1);
        if (pData.getLunhUpperCut() > 0) {
            this.luhnUpperTextField.setText(Integer.toString(pData.getLunhUpperCut()));
        } else {
            this.luhnUpperTextField.setText("");
        }
    }

    public void refreshData(ProjectionData pData) {
        pData.setStemmer((StemmerType)this.stemmerComboBox.getSelectedItem());
        pData.setUseStopword(true);
        pData.setUseWeight(false);
        pData.setLunhLowerCut(Integer.parseInt(this.luhnLowerTextField.getText()));
        pData.setMatrixTransformationType((MatrixTransformationType)this.matrixtransfComboBox.getSelectedItem());
        pData.setNumberGrams(this.gramsComboBox.getSelectedIndex() + 1);
        if (this.luhnUpperTextField.getText().trim().length() > 0) {
            pData.setLunhUpperCut(Integer.parseInt(this.luhnUpperTextField.getText()));
        } else {
            pData.setLunhUpperCut(-1);
        }
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public Vector<String> getAttributes() {
        return this.attributes;
    }
}

