/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.coodination;

import java.io.IOException;
import java.util.ArrayList;
import visualizer.graph.Vertex;
import visualizer.graph.coodination.Mapping;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.view.Viewer;

public class DistanceMapping
extends Mapping {
    private Matrix localMatrix;
    private Matrix outerMatrix;
    private int nrNeighbors = 5;
    private DissimilarityType metrictype;

    public DistanceMapping(Matrix localMatrix, Matrix outerMatrix, int nrNeighbors, DissimilarityType metrictype, Viewer local, Viewer outer) throws IOException {
        this.localMatrix = localMatrix;
        this.outerMatrix = outerMatrix;
        this.nrNeighbors = nrNeighbors;
        this.metrictype = metrictype;
        this.outer = outer;
        this.createMapping(local, outer);
    }

    @Override
    public String getName() {
        return "distance";
    }

    public void setLocalMatrix(Matrix localMatrix) {
        this.localMatrix = localMatrix;
    }

    public void setOuterMatrix(Matrix outerMatrix) {
        this.outerMatrix = outerMatrix;
    }

    public void setNrNeighbors(int nrNeighbors) {
        this.nrNeighbors = nrNeighbors;
    }

    @Override
    protected void createMapping(Viewer local, Viewer outer) throws IOException {
        if (local != null && outer != null) {
            try {
                float[][] local_points = this.localMatrix.toMatrix();
                float[][] outer_points = this.outerMatrix.toMatrix();
                ArrayList<String> common_atts = null;
                if (!this.localMatrix.getAttributes().isEmpty() && !this.outerMatrix.getAttributes().isEmpty()) {
                    common_atts = this.findCommonAtts(this.localMatrix.getAttributes(), this.outerMatrix.getAttributes());
                }
                if (common_atts != null) {
                    if (common_atts.size() < 1) {
                        throw new IOException("There are not common attributes between the projections!");
                    }
                } else if (this.localMatrix.getDimensions() == this.outerMatrix.getDimensions()) {
                    common_atts = new ArrayList();
                    for (int i = 1; i <= this.localMatrix.getDimensions(); ++i) {
                        common_atts.add("attr" + i);
                    }
                    this.localMatrix.setAttributes(common_atts);
                    this.outerMatrix.setAttributes(common_atts);
                } else {
                    throw new IOException("There are not common attributes between the projections!");
                }
                System.out.println("Number of common attributes: " + common_atts.size());
                float[][] new_local_points = this.transformMatrix(this.localMatrix.getAttributes(), common_atts, local_points);
                float[][] new_outer_points = this.transformMatrix(this.outerMatrix.getAttributes(), common_atts, outer_points);
                Dissimilarity diss = DissimilarityFactory.getInstance(this.metrictype);
                for (int i = 0; i < new_outer_points.length; ++i) {
                    float distance;
                    int j;
                    Pair[] pairList = new Pair[this.nrNeighbors];
                    for (j = 0; j < this.nrNeighbors; ++j) {
                        distance = diss.calculate(this.outerMatrix.getRow(i), this.localMatrix.getRow(j));
                        pairList[j] = new Pair(j, distance);
                    }
                    for (j = this.nrNeighbors; j < new_local_points.length; ++j) {
                        distance = diss.calculate(this.outerMatrix.getRow(i), this.localMatrix.getRow(j));
                        this.addDistance(pairList, new Pair(j, distance));
                    }
                    Vertex v_outer = outer.getGraph().getVertex().get(i);
                    Mapping.Map m = new Mapping.Map(this);
                    m.outer = v_outer;
                    for (int j2 = 0; j2 < pairList.length; ++j2) {
                        Vertex v_local = local.getGraph().getVertex().get(pairList[j2].id);
                        m.local.add(v_local);
                    }
                    this.mapping.add(m);
                }
            }
            catch (IOException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("End of Distance Coordination Mapping");
        }
    }

    public void addDistance(Pair[] pairList, Pair newPair) {
        if (pairList[0].distance > newPair.distance) {
            for (int i = 0; i < pairList.length && pairList[i].distance > newPair.distance; ++i) {
                if (i >= pairList.length - 1) continue;
                pairList[i] = pairList[i + 1];
            }
            pairList[i - 1] = newPair;
        }
    }

    public float[][] transformMatrix(ArrayList<String> old_atts, ArrayList<String> new_atts, float[][] old_matrix) {
        int i;
        float[][] new_matrix = new float[old_matrix.length][];
        for (i = 0; i < new_matrix.length; ++i) {
            new_matrix[i] = new float[new_atts.size()];
        }
        for (i = 0; i < new_atts.size(); ++i) {
            int j;
            int old_index = 0;
            for (j = 0; j < old_atts.size(); ++j) {
                if (!old_atts.get(j).equals(new_atts.get(i))) continue;
                old_index = j;
                break;
            }
            for (j = 0; j < new_matrix.length; ++j) {
                new_matrix[j][i] = old_matrix[j][old_index];
            }
        }
        return new_matrix;
    }

    public ArrayList<String> findCommonAtts(ArrayList<String> atts_1, ArrayList<String> atts_2) {
        ArrayList<String> final_atts = new ArrayList<String>();
        block0: for (int i = 0; i < atts_1.size(); ++i) {
            for (int j = 0; j < atts_2.size(); ++j) {
                if (!atts_1.get(i).equals(atts_2.get(j))) continue;
                final_atts.add(atts_1.get(i));
                continue block0;
            }
        }
        return final_atts;
    }

    public static class Pair {
        public int id;
        public float distance;

        public Pair(int id, float distance) {
            this.id = id;
            this.distance = distance;
        }
    }
}

