/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.coodination;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import visualizer.graph.coodination.TopicMapping;
import visualizer.view.Viewer;

public class TopicMappingView
extends JDialog {
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel framesPanel;

    private TopicMappingView(Frame parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
    }

    private void initComponents() {
        this.framesPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.framesPanel.setLayout(new GridBagLayout());
        this.framesPanel.setBorder(BorderFactory.createTitledBorder("Select Mappings"));
        this.getContentPane().add((Component)this.framesPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopicMappingView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static TopicMappingView getInstance(JFrame parent) {
        return new TopicMappingView(parent);
    }

    public void display(JInternalFrame[] frames) {
        ArrayList<Viewer> gvFrames = new ArrayList<Viewer>();
        for (JInternalFrame jif : frames) {
            if (!(jif instanceof Viewer)) continue;
            gvFrames.add((Viewer)jif);
        }
        this.setProjectionsNames(gvFrames);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void setProjectionsNames(ArrayList<Viewer> frames) {
        for (int i = 0; i < frames.size(); ++i) {
            if (!frames.get(i).getGraph().isCorpus()) continue;
            for (int j = 0; j < frames.size(); ++j) {
                if (i == j || !frames.get(j).getGraph().isCorpus()) continue;
                JCheckBox check = new JCheckBox("Projection [" + frames.get(i).getId() + "] >>> " + "Projection [" + frames.get(j).getId() + "]");
                check.addActionListener(new CheckBoxListener(frames.get(i), frames.get(j)));
                GridBagConstraints cons = new GridBagConstraints();
                cons.anchor = 17;
                cons.gridx = 0;
                cons.gridy = i * frames.size() + j;
                this.framesPanel.add((Component)check, cons);
            }
        }
        this.pack();
    }

    class CheckBoxListener
    implements ActionListener {
        private Viewer from;
        private Viewer to;

        public CheckBoxListener(Viewer from, Viewer to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JCheckBox && ((JCheckBox)e.getSource()).isSelected()) {
                try {
                    TopicMapping mapping = new TopicMapping(this.to, this.from);
                    this.to.getCoordination().addToCoordinate(mapping);
                    this.to.updateCoordinations(null);
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

