/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.listeners;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.graph.listeners.CoordinateSelectionListener;
import visualizer.graph.listeners.VertexSelectionListener;
import visualizer.topic.Topic;
import visualizer.topic.TopicData;
import visualizer.topic.TopicFactory;
import visualizer.util.OpenDialog;
import visualizer.view.Viewer;

public class CreateTopicSelectionListener
extends VertexSelectionListener {
    public CreateTopicSelectionListener(Viewer panel) {
        super(panel);
        this.color = Color.YELLOW;
    }

    @Override
    public ArrayList<Vertex> vertexSelected(Object param, ArrayList<Vertex> vertex) {
        if (vertex.size() > 0) {
            this.panel.getGraph().addScalar("topics");
            if (this.panel.getGraph().getTopicData().getTopicType() == TopicData.TopicType.COVARIANCE) {
                if (OpenDialog.checkCorpus(this.panel.getGraph(), this.panel.getProjectionExplorerView())) {
                    Topic topic = TopicFactory.getInstance(this.panel.getGraph(), this.panel.getGraph().getTopicData(), this.panel.getGraph().getCorpus(), vertex);
                    this.panel.addTopic(topic);
                    this.panel.updateScalars(this.panel.getGraph().getScalarByName("topics"));
                    this.panel.updateImage();
                    if (topic != null) {
                        CoordinateSelectionListener coord = new CoordinateSelectionListener(this.panel);
                        String query = topic.getQuery();
                        if (query != null) {
                            coord.vertexSelected(query, vertex);
                        }
                    }
                }
            } else if (OpenDialog.checkCorpus(this.panel.getGraph(), this.panel.getProjectionExplorerView())) {
                Topic topic = TopicFactory.getInstance(this.panel.getGraph(), this.panel.getGraph().getTopicData(), this.panel.getGraph().getCorpus(), vertex);
                this.createQueryFromTopic(topic);
                this.panel.addTopic(topic);
            }
        }
        return null;
    }

    private void createQueryFromTopic(Topic topic) {
        String query = topic.getQuery();
        if (query != null && !query.equals("")) {
            try {
                Scalar s = this.panel.getGraph().createQueryScalar(query);
                this.panel.updateScalars(s);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

