/*
 * Decompiled with CFR 0.152.
 */
package visualizer.matrix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.SparseMatrix;
import visualizer.matrix.Vector;

public abstract class Matrix {
    protected int dimensions;
    protected ArrayList<String> attributes = new ArrayList();
    protected ArrayList<Vector> rows = new ArrayList();

    public abstract void load(String var1) throws IOException;

    public abstract void save(String var1) throws IOException;

    public boolean contains(Vector vector) {
        return this.rows.contains(vector);
    }

    public void addRow(Vector vector) {
        assert (this.rows.isEmpty() || this.dimensions == vector.size()) : "ERROR: vector of wrong size!";
        this.rows.add(vector);
        this.dimensions = vector.size();
    }

    public void setRow(int index, Vector vector) {
        assert (this.rows.size() > index && this.dimensions == vector.size()) : "ERROR: wrong index or vector of wrong size!";
        this.rows.set(index, vector);
    }

    public Vector removeRow(int index) {
        assert (this.rows.size() > index) : "ERROR: wrong index!";
        return this.rows.remove(index);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Vector getRow(int row) {
        assert (this.rows.size() > row) : "ERROR: this row does not exists in the matrix!";
        return this.rows.get(row);
    }

    public void normalize() {
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            if (!this.rows.get(i).isNull()) {
                this.rows.get(i).normalize();
                continue;
            }
            Logger.getLogger(Matrix.class.getName()).log(Level.INFO, "Ignoring null vector on the normalization.");
        }
    }

    public float[][] toMatrix() {
        float[][] matrix = new float[this.rows.size()][];
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            matrix[i] = this.rows.get(i).toArray();
        }
        return matrix;
    }

    public ArrayList<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ArrayList<String> attributes) {
        assert (this.rows.isEmpty() || this.dimensions == attributes.size()) : "ERROR: attributes and vectors of different sizes!";
        this.attributes = attributes;
    }

    public ArrayList<String> getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            ids.add(this.rows.get(i).getId());
        }
        return ids;
    }

    public float[] getClassData() {
        float[] cdata = new float[this.rows.size()];
        for (int i = 0; i < cdata.length; ++i) {
            cdata[i] = this.rows.get(i).getKlass();
        }
        return cdata;
    }

    public Object clone() throws CloneNotSupportedException {
        SparseMatrix clone = new SparseMatrix();
        clone.dimensions = this.dimensions;
        for (String attr : this.attributes) {
            clone.attributes.add(attr);
        }
        for (Vector v : this.rows) {
            clone.rows.add((Vector)v.clone());
        }
        return clone;
    }
}

