/*
 * Decompiled with CFR 0.152.
 */
package visualizer.matrix.normalization;

import java.util.ArrayList;

public class NormalizationType {
    public static final NormalizationType NONE;
    public static final NormalizationType VECTORS_UNIT_LENGTH;
    public static final NormalizationType NORMALIZE_COLUMNS;
    public static final NormalizationType STANDARDIZATION;
    private static ArrayList<NormalizationType> types;
    private String name;

    private NormalizationType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<NormalizationType> getTypes() {
        return types;
    }

    public static NormalizationType retrieve(String name) {
        for (NormalizationType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NormalizationType other = (NormalizationType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        NONE = new NormalizationType("None");
        VECTORS_UNIT_LENGTH = new NormalizationType("Vectors with unit length");
        NORMALIZE_COLUMNS = new NormalizationType("Normalize columns [0,1]");
        STANDARDIZATION = new NormalizationType("Standardization");
    }
}

