/*
 * Decompiled with CFR 0.152.
 */
package visualizer.matrix.normalization;

import java.io.IOException;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.matrix.SparseMatrix;
import visualizer.matrix.SparseVector;
import visualizer.matrix.Vector;
import visualizer.matrix.normalization.Normalization;

public class NormalizeColumns
extends Normalization {
    @Override
    public Matrix execute(Matrix matrix) throws IOException {
        assert (matrix.getRowCount() > 0) : "More than zero vectors must be used!";
        float[][] points = matrix.toMatrix();
        for (int j = 0; j < matrix.getDimensions(); ++j) {
            int i;
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (i = 0; i < matrix.getRowCount(); ++i) {
                if (max < points[i][j]) {
                    max = points[i][j];
                }
                if (!(min > points[i][j])) continue;
                min = points[i][j];
            }
            for (i = 0; i < matrix.getRowCount(); ++i) {
                points[i][j] = max > min ? (points[i][j] - min) / (max - min) : 0.0f;
            }
        }
        Matrix colmatrix = null;
        colmatrix = matrix instanceof SparseMatrix ? new SparseMatrix() : new DenseMatrix();
        colmatrix.setAttributes(matrix.getAttributes());
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            Vector oldv = matrix.getRow(i);
            if (matrix instanceof SparseMatrix) {
                colmatrix.addRow(new SparseVector(points[i], oldv.getId(), oldv.getKlass()));
                continue;
            }
            colmatrix.addRow(new DenseVector(points[i], oldv.getId(), oldv.getKlass()));
        }
        return colmatrix;
    }
}

