/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.Euclidean;

public class ForceScheme {
    private float fractionDelta;
    private int[] index;
    private static final float EPSILON = 1.0E-7f;

    public ForceScheme(float fractionDelta, int numberPoints) {
        this.fractionDelta = fractionDelta;
        ArrayList<Integer> index_aux = new ArrayList<Integer>();
        for (int i = 0; i < numberPoints; ++i) {
            index_aux.add(i);
        }
        this.index = new int[numberPoints];
        int ind = 0;
        for (int j = 0; j < this.index.length; ++j) {
            if (ind >= index_aux.size()) {
                ind = 0;
            }
            this.index[j] = (Integer)index_aux.get(ind);
            index_aux.remove(ind);
            ind += index_aux.size() / 10;
        }
    }

    public float iteration(DistanceMatrix dmat, float[][] projection) {
        float error = 0.0f;
        if (projection[0].length == 2) {
            for (int ins1 = 0; ins1 < projection.length; ++ins1) {
                int instance = this.index[ins1];
                for (int ins2 = 0; ins2 < projection.length; ++ins2) {
                    int instance2 = this.index[ins2];
                    if (instance == instance2) continue;
                    float x1x2 = projection[instance2][0] - projection[instance][0];
                    float y1y2 = projection[instance2][1] - projection[instance][1];
                    float dr2 = (float)Math.sqrt(x1x2 * x1x2 + y1y2 * y1y2);
                    if (dr2 < 1.0E-7f) {
                        dr2 = 1.0E-7f;
                    }
                    float drn = dmat.getDistance(instance, instance2);
                    float normdrn = (drn - dmat.getMinDistance()) / (dmat.getMaxDistance() - dmat.getMinDistance());
                    float delta = normdrn - dr2;
                    delta *= Math.abs(delta);
                    error += Math.abs(delta /= this.fractionDelta);
                    float[] fArray = projection[instance2];
                    fArray[0] = fArray[0] + delta * (x1x2 / dr2);
                    float[] fArray2 = projection[instance2];
                    fArray2[1] = fArray2[1] + delta * (y1y2 / dr2);
                }
            }
            error /= (float)(projection.length * projection.length - projection.length);
        } else if (projection[0].length == 3) {
            for (int ins1 = 0; ins1 < projection.length; ++ins1) {
                int instance = this.index[ins1];
                for (int ins2 = 0; ins2 < projection.length; ++ins2) {
                    int instance2 = this.index[ins2];
                    if (instance == instance2) continue;
                    float x1x2 = projection[instance2][0] - projection[instance][0];
                    float y1y2 = projection[instance2][1] - projection[instance][1];
                    float z1z2 = projection[instance2][2] - projection[instance][2];
                    float dr3 = (float)Math.sqrt(x1x2 * x1x2 + y1y2 * y1y2 + z1z2 * z1z2);
                    if (dr3 < 1.0E-7f) {
                        dr3 = 1.0E-7f;
                    }
                    float drn = dmat.getDistance(instance, instance2);
                    float normdrn = (drn - dmat.getMinDistance()) / (dmat.getMaxDistance() - dmat.getMinDistance());
                    float delta = normdrn - dr3;
                    delta *= Math.abs(delta);
                    error += Math.abs(delta /= this.fractionDelta);
                    float[] fArray = projection[instance2];
                    fArray[0] = fArray[0] + delta * (x1x2 / dr3);
                    float[] fArray3 = projection[instance2];
                    fArray3[1] = fArray3[1] + delta * (y1y2 / dr3);
                    float[] fArray4 = projection[instance2];
                    fArray4[2] = fArray4[2] + delta * (z1z2 / dr3);
                }
            }
            error /= (float)(projection.length * projection.length - projection.length);
        }
        return error;
    }

    public float iteration(Matrix matrix, Dissimilarity diss, float[][] projection) {
        float error = 0.0f;
        if (projection[0].length == 2) {
            for (int ins1 = 0; ins1 < projection.length; ++ins1) {
                int instance = this.index[ins1];
                for (int ins2 = 0; ins2 < projection.length; ++ins2) {
                    int instance2 = this.index[ins2];
                    if (instance == instance2) continue;
                    float x1x2 = projection[instance2][0] - projection[instance][0];
                    float y1y2 = projection[instance2][1] - projection[instance][1];
                    float dr2 = (float)Math.sqrt(x1x2 * x1x2 + y1y2 * y1y2);
                    if (dr2 < 1.0E-7f) {
                        dr2 = 1.0E-7f;
                    }
                    float drn = diss.calculate(matrix.getRow(instance), matrix.getRow(instance2));
                    float normdrn = drn / 5.0f;
                    float delta = normdrn - dr2;
                    delta *= Math.abs(delta);
                    error += Math.abs(delta /= this.fractionDelta);
                    float[] fArray = projection[instance2];
                    fArray[0] = fArray[0] + delta * (x1x2 / dr2);
                    float[] fArray2 = projection[instance2];
                    fArray2[1] = fArray2[1] + delta * (y1y2 / dr2);
                }
            }
            error /= (float)(projection.length * projection.length - projection.length);
        } else if (projection[0].length == 3) {
            for (int ins1 = 0; ins1 < projection.length; ++ins1) {
                int instance = this.index[ins1];
                for (int ins2 = 0; ins2 < projection.length; ++ins2) {
                    int instance2 = this.index[ins2];
                    if (instance == instance2) continue;
                    float x1x2 = projection[instance2][0] - projection[instance][0];
                    float y1y2 = projection[instance2][1] - projection[instance][1];
                    float z1z2 = projection[instance2][2] - projection[instance][2];
                    float dr3 = (float)Math.sqrt(x1x2 * x1x2 + y1y2 * y1y2 + z1z2 * z1z2);
                    if (dr3 < 1.0E-7f) {
                        dr3 = 1.0E-7f;
                    }
                    float drn = diss.calculate(matrix.getRow(instance), matrix.getRow(instance2));
                    float normdrn = drn / 5.0f;
                    float delta = normdrn - dr3;
                    delta *= Math.abs(delta);
                    error += Math.abs(delta /= this.fractionDelta);
                    float[] fArray = projection[instance2];
                    fArray[0] = fArray[0] + delta * (x1x2 / dr3);
                    float[] fArray3 = projection[instance2];
                    fArray3[1] = fArray3[1] + delta * (y1y2 / dr3);
                    float[] fArray4 = projection[instance2];
                    fArray4[2] = fArray4[2] + delta * (z1z2 / dr3);
                }
            }
        }
        return error;
    }

    public static void main(String[] args) {
        try {
            String filename = "D:\\My Documents\\FERNANDO\\Tese\\datasets\\quadrapeds-mammals_nc.data";
            Matrix matrix = MatrixFactory.getInstance(filename);
            float[][] projection = new float[matrix.getRowCount()][];
            for (int i = 0; i < projection.length; ++i) {
                projection[i] = new float[2];
                projection[i][0] = (float)Math.random();
                projection[i][1] = (float)Math.random();
            }
            ForceScheme force = new ForceScheme(8.0f, matrix.getRowCount());
            for (int i = 0; i < 1; ++i) {
                float error = force.iteration(matrix, new Euclidean(), projection);
                System.out.println(error);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ForceScheme.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

