/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.Corpus;
import visualizer.corpus.CorpusFactory;
import visualizer.datamining.clustering.HierarchicalClustering;
import visualizer.datamining.clustering.HierarchicalClusteringType;
import visualizer.dimensionreduction.DimensionalityReduction;
import visualizer.dimensionreduction.DimensionalityReductionFactory;
import visualizer.dimensionreduction.DimensionalityReductionType;
import visualizer.featureextraction.ExtractionManager;
import visualizer.graph.Connectivity;
import visualizer.graph.Graph;
import visualizer.graph.ImageCollection;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.matrix.normalization.Normalization;
import visualizer.matrix.normalization.NormalizationFactory;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.ProjectionFactory;
import visualizer.projection.SourceType;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.DistanceMatrixFactory;
import visualizer.projection.distance.Euclidean;
import visualizer.util.SystemPropertiesManager;
import visualizer.util.Util;
import visualizer.wizard.ProjectionView;

public class GraphBuilder {
    private IOException exception;
    private Thread t;
    private Graph graph;
    private ProjectionView view;
    private DistanceMatrix dmat;
    private Matrix matrix;

    public GraphBuilder(ProjectionView view, Graph graph) {
        this.view = view;
        this.graph = graph;
        this.exception = null;
    }

    public void start() {
        this.t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GraphBuilder.this.createGraph(GraphBuilder.this.graph.getProjectionData());
                    GraphBuilder.this.dispose();
                    Runtime.getRuntime().gc();
                }
                catch (IOException ex) {
                    GraphBuilder.this.exception = ex;
                }
                finally {
                    GraphBuilder.this.view.finished(GraphBuilder.this.exception);
                }
            }
        };
        this.t.start();
    }

    public void stop() {
        if (this.t.isAlive()) {
            this.t.interrupt();
            this.dispose();
            Runtime.getRuntime().gc();
        }
    }

    private void createGraph(ProjectionData pdata) throws IOException {
        int i;
        String id;
        float[] cdata = null;
        ArrayList<String> ids = null;
        float[][] projection = null;
        Projection proj = null;
        if (pdata.getSourceType() == SourceType.DISTANCE_MATRIX || pdata.getDissimilarityType() == DissimilarityType.KOLMOGOROV) {
            this.dmat = DistanceMatrixFactory.getInstance(this.view, pdata);
            cdata = this.dmat.getClassData();
            ids = this.dmat.getIds();
            this.saveData(pdata, this.dmat, null);
            proj = ProjectionFactory.getInstance(pdata.getProjectionType());
            projection = proj.project(this.dmat, pdata, this.view);
            pdata.setNumberObjects(this.dmat.getElementCount());
        } else if (pdata.getSourceType() == SourceType.IMAGES) {
            this.matrix = new DenseMatrix();
            String unzipDir = SystemPropertiesManager.getInstance().getProperty("UNZIP.DIR");
            Util.deleteFiles(unzipDir);
            this.view.setStatus("Unziping Images..." + pdata.getSourceFile(), 5);
            Util.unzipImages(pdata.getSourceFile());
            this.view.setStatus("Extracting Features..." + pdata.getSourceFile(), 15);
            ExtractionManager EM = new ExtractionManager(pdata, unzipDir);
            float[][] points = EM.getMatrixPoints();
            cdata = EM.getClassData();
            ids = EM.getNameImages();
            for (int i2 = 0; i2 < points.length; ++i2) {
                this.matrix.addRow(new DenseVector(points[i2], ids.get(i2), cdata[i2]));
            }
            Normalization norm = NormalizationFactory.getInstance(pdata.getNormalization());
            this.matrix = norm.execute(this.matrix);
            this.graph.setImageCollection(new ImageCollection(pdata.getSourceFile()));
            this.saveData(pdata, null, this.matrix);
            proj = ProjectionFactory.getInstance(pdata.getProjectionType());
            projection = proj.project(this.matrix, pdata, this.view);
            pdata.setNumberObjects(this.matrix.getRowCount());
            pdata.setNumberDimensions(this.matrix.getDimensions());
            this.dmat = proj.getDistanceMatrix();
            this.saveData(pdata, this.dmat, null);
        } else {
            this.matrix = MatrixFactory.getInstance(this.view, pdata);
            cdata = this.matrix.getClassData();
            ids = this.matrix.getIds();
            Normalization norm = NormalizationFactory.getInstance(pdata.getNormalization());
            this.matrix = norm.execute(this.matrix);
            if (pdata.getDimensionReductionType() != DimensionalityReductionType.NONE && this.matrix.getDimensions() > pdata.getTargetDimension()) {
                this.view.setStatus("Reducing the dimensions to " + pdata.getTargetDimension() + " dimensions...", 10);
                DimensionalityReduction dr = DimensionalityReductionFactory.getInstance(pdata.getDimensionReductionType(), pdata.getTargetDimension());
                Dissimilarity diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
                this.matrix = dr.reduce(this.matrix, diss);
            }
            this.saveData(pdata, null, this.matrix);
            proj = ProjectionFactory.getInstance(pdata.getProjectionType());
            projection = proj.project(this.matrix, pdata, this.view);
            pdata.setNumberObjects(this.matrix.getRowCount());
            pdata.setNumberDimensions(this.matrix.getDimensions());
            this.dmat = proj.getDistanceMatrix();
            this.saveData(pdata, this.dmat, null);
        }
        ArrayList<Vertex> vertex = new ArrayList<Vertex>();
        for (int i3 = 0; i3 < projection.length; ++i3) {
            Vertex v = new Vertex(i3, projection[i3][0], projection[i3][1]);
            if (ids.size() > i3) {
                v.setUrl(ids.get(i3));
            } else {
                v.setUrl("");
            }
            vertex.add(v);
        }
        this.graph.setVertex(vertex);
        if (pdata.getSourceType() == SourceType.CORPUS) {
            Corpus cp = CorpusFactory.getInstance(pdata.getSourceFile(), pdata);
            this.graph.setCorpus(cp);
            int title = this.graph.addTitle("title");
            for (int i4 = 0; i4 < vertex.size(); ++i4) {
                if (ids.size() > i4) {
                    id = vertex.get(i4).getUrl();
                    vertex.get(i4).setTitle(title, cp.getTitle(pdata.getNumberLines(), id));
                    continue;
                }
                vertex.get(i4).setTitle(title, "");
            }
        }
        int fname = this.graph.addTitle("file name");
        for (Vertex v : vertex) {
            id = v.getUrl();
            v.setTitle(fname, id);
        }
        if (pdata.getTitlesFile() != null && pdata.getTitlesFile().trim().length() > 0) {
            Util.importTitles(this.graph, pdata.getTitlesFile());
        }
        this.graph.setDescription(pdata.getDescription());
        Scalar sdots = this.graph.addScalar("...");
        Scalar scdata = this.graph.addScalar("cdata");
        for (int i5 = 0; i5 < projection.length; ++i5) {
            vertex.get(i5).setScalar(sdots, 0.0f);
            if (cdata.length > i5) {
                vertex.get(i5).setScalar(scdata, cdata[i5]);
                continue;
            }
            vertex.get(i5).setScalar(scdata, 0.0f);
        }
        if (this.matrix != null) {
            boolean hasNullVectors = false;
            for (i = 0; i < this.matrix.getRowCount(); ++i) {
                if (!this.matrix.getRow(i).isNull()) continue;
                hasNullVectors = true;
                break;
            }
            if (hasNullVectors) {
                Scalar snull = this.graph.addScalar("null vectors");
                for (int i6 = 0; i6 < projection.length; ++i6) {
                    if (this.matrix.getRowCount() > i6 && this.matrix.getRow(i6).isNull()) {
                        vertex.get(i6).setScalar(snull, 1.0f);
                        continue;
                    }
                    vertex.get(i6).setScalar(snull, 0.0f);
                }
            }
        }
        if (pdata.getHierarchicalClusteringType() != HierarchicalClusteringType.NONE) {
            if (this.view != null) {
                this.view.setStatus("Creating the Hierarchical Clustering...", 85);
            }
            DenseMatrix dproj = new DenseMatrix();
            for (i = 0; i < projection.length; ++i) {
                dproj.addRow(new DenseVector(projection[i]));
            }
            HierarchicalClusteringType type = pdata.getHierarchicalClusteringType();
            float[] hcScalars = this.createHC(dproj, type);
            Scalar shc = null;
            if (type == HierarchicalClusteringType.ALINK) {
                shc = this.graph.addScalar("hc-alink");
            } else if (type == HierarchicalClusteringType.CLINK) {
                shc = this.graph.addScalar("hc-clink");
            } else if (type == HierarchicalClusteringType.SLINK) {
                shc = this.graph.addScalar("hc-slink");
            }
            for (int i7 = 0; i7 < hcScalars.length; ++i7) {
                vertex.get(i7).setScalar(shc, hcScalars[i7]);
            }
        }
        if (this.view != null) {
            this.view.setStatus("Creating the connectivities...", 90);
        }
        Connectivity dotsCon = new Connectivity("...");
        this.graph.addConnectivity(dotsCon);
        proj.createConnectivities(this.graph, pdata, this.view);
        proj.postProcessing(this.graph);
        this.saveTitles(pdata, this.graph);
        this.view.setStatus("Done!", 100);
    }

    public void dispose() {
        this.dmat = null;
        this.matrix = null;
    }

    private float[] createHC(Matrix matrix, HierarchicalClusteringType type) throws IOException {
        HierarchicalClustering hc = new HierarchicalClustering(type);
        return hc.getPointsHeight(matrix, new Euclidean());
    }

    private void saveTitles(ProjectionData pdata, Graph graph) {
        if (pdata.getDocsTermsFilename().trim().length() > 0 || pdata.getDistanceMatrixFilename().trim().length() > 0) {
            try {
                String filename = pdata.getDocsTermsFilename();
                if (filename.trim().length() == 0) {
                    filename = pdata.getDistanceMatrixFilename();
                }
                filename = filename.substring(0, filename.length() - 4) + "titles";
                Util.exportTitles(graph, filename);
            }
            catch (IOException ex) {
                Logger.getLogger(GraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void saveData(ProjectionData pdata, DistanceMatrix dmat, Matrix matrix) throws IOException {
        String filename;
        if (matrix != null && pdata.getDocsTermsFilename().trim().length() > 0) {
            filename = pdata.getDocsTermsFilename();
            matrix.save(filename);
        }
        if (dmat != null && pdata.getDistanceMatrixFilename().trim().length() > 0) {
            filename = pdata.getDistanceMatrixFilename();
            dmat.save(filename);
        }
    }
}

