/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import visualizer.projection.Projector;
import visualizer.projection.distance.DistanceMatrix;

public class NearestNeighborProjection
extends Projector {
    private static final float EPSILON = 1.0E-5f;

    @Override
    public float[][] project(DistanceMatrix dmat) {
        float[][] projection = new float[dmat.getElementCount()][];
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            projection[i] = new float[2];
        }
        projection[0][0] = 0.0f;
        projection[0][1] = 0.0f;
        projection[1][0] = 0.0f;
        projection[1][1] = dmat.getDistance(0, 1);
        for (int x = 2; x < dmat.getElementCount(); ++x) {
            Pair resultingIntersections;
            int number;
            int q = 0;
            int r = 1;
            float minDistance1 = dmat.getMaxDistance();
            float minDistance2 = dmat.getMaxDistance();
            for (int _ins = 0; _ins < x; ++_ins) {
                float distance = dmat.getDistance(x, _ins);
                if (minDistance1 > distance) {
                    r = q;
                    minDistance2 = minDistance1;
                    q = _ins;
                    minDistance1 = distance;
                    continue;
                }
                if (!(minDistance2 > distance)) continue;
                minDistance2 = distance;
                r = _ins;
            }
            Circle circle1 = new Circle();
            Circle circle2 = new Circle();
            circle1.center.x = projection[q][0];
            circle1.center.y = projection[q][1];
            circle1.radius = dmat.getDistance(q, x);
            circle2.center.x = projection[r][0];
            circle2.center.y = projection[r][1];
            circle2.radius = dmat.getDistance(r, x);
            if (circle1.center.x - circle2.center.x < 1.0E-5f) {
                circle1.center.x += 1.0E-5f;
            }
            if (circle1.center.y - circle2.center.y < 1.0E-5f) {
                circle1.center.y += 1.0E-5f;
            }
            if ((number = this.intersect(circle1, circle2, resultingIntersections = new Pair())) == 1) {
                projection[x][0] = resultingIntersections.first.x;
                projection[x][1] = resultingIntersections.first.y;
                continue;
            }
            float distanceQX = dmat.getDistance(q, x);
            float distanceRX = dmat.getDistance(r, x);
            float distanceQX1 = (float)Math.sqrt((projection[q][0] - resultingIntersections.first.x) * (projection[q][0] - resultingIntersections.first.x) + (projection[q][1] - resultingIntersections.first.y) * (projection[q][1] - resultingIntersections.first.y));
            float distanceQX2 = (float)Math.sqrt((projection[q][0] - resultingIntersections.second.x) * (projection[q][0] - resultingIntersections.second.x) + (projection[q][1] - resultingIntersections.second.y) * (projection[q][1] - resultingIntersections.second.y));
            float distanceRX1 = (float)Math.sqrt((projection[r][0] - resultingIntersections.first.x) * (projection[r][0] - resultingIntersections.first.x) + (projection[r][1] - resultingIntersections.first.y) * (projection[r][1] - resultingIntersections.first.y));
            float distanceRX2 = (float)Math.sqrt((projection[r][0] - resultingIntersections.second.x) * (projection[r][0] - resultingIntersections.second.x) + (projection[r][1] - resultingIntersections.second.y) * (projection[r][1] - resultingIntersections.second.y));
            if (Math.abs(distanceQX / distanceQX1 - 1.0f) + Math.abs(distanceRX / distanceRX1 - 1.0f) < Math.abs(distanceQX / distanceQX2 - 1.0f) + Math.abs(distanceRX / distanceRX2 - 1.0f)) {
                projection[x][0] = resultingIntersections.first.x;
                projection[x][1] = resultingIntersections.first.y;
                continue;
            }
            projection[x][0] = resultingIntersections.second.x;
            projection[x][1] = resultingIntersections.second.y;
        }
        this.normalize2D(projection);
        return projection;
    }

    private int intersect(Circle circle1, Circle circle2, Pair intersect) {
        float lvdistance = (float)Math.sqrt((circle1.center.x - circle2.center.x) * (circle1.center.x - circle2.center.x) + (circle1.center.y - circle2.center.y) * (circle1.center.y - circle2.center.y));
        if (lvdistance > circle1.radius + circle2.radius) {
            float lvdifference = lvdistance - (circle1.radius + circle2.radius);
            if (circle1.center.x < circle2.center.x) {
                float m = (circle2.center.y - circle1.center.y) / (circle2.center.x - circle1.center.x);
                intersect.first.x = circle1.center.x;
                intersect.first.y = circle1.center.y;
                float lvdeloc = circle1.radius;
                intersect.first.x = (float)((double)intersect.first.x + Math.sqrt((lvdeloc += lvdifference / 2.0f) * lvdeloc / (1.0f + m * m)));
                intersect.first.y = (float)((double)intersect.first.y + (double)m * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
            } else {
                float m = (circle1.center.y - circle2.center.y) / (circle1.center.x - circle2.center.x);
                intersect.first.x = circle2.center.x;
                intersect.first.y = circle2.center.y;
                float lvdeloc = circle2.radius;
                intersect.first.x = (float)((double)intersect.first.x + Math.sqrt((lvdeloc += lvdifference / 2.0f) * lvdeloc / (1.0f + m * m)));
                intersect.first.y = (float)((double)intersect.first.y + (double)m * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
            }
            return 1;
        }
        if (lvdistance < Math.abs(circle1.radius - circle2.radius)) {
            if (circle1.radius > circle2.radius) {
                float lvdeloc = circle2.radius + lvdistance + (circle1.radius - circle2.radius - lvdistance) / 2.0f;
                float m = (circle2.center.y - circle1.center.y) / (circle2.center.x - circle1.center.x);
                intersect.first.x = circle1.center.x;
                intersect.first.y = circle1.center.y;
                if (circle2.center.y >= circle1.center.y && circle2.center.x >= circle1.center.x) {
                    intersect.first.x = (float)((double)intersect.first.x + Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                    intersect.first.y = (float)((double)intersect.first.y + (double)Math.abs(m) * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                } else if (circle2.center.y >= circle1.center.y && circle2.center.x <= circle1.center.x) {
                    intersect.first.x = (float)((double)intersect.first.x - Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                    intersect.first.y = (float)((double)intersect.first.y + (double)Math.abs(m) * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                } else if (circle2.center.y <= circle1.center.y && circle2.center.x <= circle1.center.x) {
                    intersect.first.x = (float)((double)intersect.first.x - Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                    intersect.first.y = (float)((double)intersect.first.y - (double)Math.abs(m) * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                } else {
                    intersect.first.x = (float)((double)intersect.first.x + Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                    intersect.first.y = (float)((double)intersect.first.y - (double)Math.abs(m) * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                }
            } else {
                float lvdeloc = circle1.radius + lvdistance + (circle2.radius - circle1.radius - lvdistance) / 2.0f;
                float m = (circle1.center.y - circle2.center.y) / (circle1.center.x - circle2.center.x);
                intersect.first.x = circle2.center.x;
                intersect.first.y = circle2.center.y;
                if (circle1.center.y >= circle2.center.y && circle1.center.x >= circle2.center.x) {
                    intersect.first.x = (float)((double)intersect.first.x + Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                    intersect.first.y = (float)((double)intersect.first.y + (double)Math.abs(m) * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                } else if (circle1.center.y >= circle2.center.y && circle1.center.x <= circle2.center.x) {
                    intersect.first.x = (float)((double)intersect.first.x - Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                    intersect.first.y = (float)((double)intersect.first.y + (double)Math.abs(m) * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                } else if (circle1.center.y <= circle2.center.y && circle1.center.x <= circle2.center.x) {
                    intersect.first.x = (float)((double)intersect.first.x - Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                    intersect.first.y = (float)((double)intersect.first.y - (double)Math.abs(m) * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                } else {
                    intersect.first.x = (float)((double)intersect.first.x + Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                    intersect.first.y = (float)((double)intersect.first.y - (double)Math.abs(m) * Math.sqrt(lvdeloc * lvdeloc / (1.0f + m * m)));
                }
            }
            return 1;
        }
        float a = (circle1.radius * circle1.radius - circle2.radius * circle2.radius + lvdistance * lvdistance) / (2.0f * lvdistance);
        float h = (float)Math.sqrt(circle1.radius * circle1.radius - a * a);
        float x2 = circle1.center.x + a * (circle2.center.x - circle1.center.x) / lvdistance;
        float y2 = circle1.center.y + a * (circle2.center.y - circle1.center.y) / lvdistance;
        float x31 = x2 + h * (circle2.center.y - circle1.center.y) / lvdistance;
        float x32 = x2 - h * (circle2.center.y - circle1.center.y) / lvdistance;
        float y31 = y2 - h * (circle2.center.x - circle1.center.x) / lvdistance;
        float y32 = y2 + h * (circle2.center.x - circle1.center.x) / lvdistance;
        intersect.first.x = x31;
        intersect.first.y = y31;
        intersect.second.x = x32;
        intersect.second.y = y32;
        return 2;
    }

    class Circle {
        Point center;
        float radius;

        Circle() {
            this.center = new Point();
        }

        public String toString() {
            return "center: (" + this.center.x + ", " + this.center.y + ") and radius: " + this.radius;
        }
    }

    class Pair {
        Point first;
        Point second;

        Pair() {
            this.first = new Point();
            this.second = new Point();
        }
    }

    class Point {
        float x;
        float y;

        Point() {
        }
    }
}

