/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.util.ArrayList;

public class ProjectorType {
    public static final ProjectorType FASTMAP;
    public static final ProjectorType NNP;
    public static final ProjectorType NONE;
    private static ArrayList<ProjectorType> types;
    private String name;

    private ProjectorType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<ProjectorType> getCompressors() {
        return types;
    }

    public static ProjectorType retrieve(String name) {
        for (ProjectorType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectorType other = (ProjectorType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        FASTMAP = new ProjectorType("Fastmap");
        NNP = new ProjectorType("NNP");
        NONE = new ProjectorType("None");
    }
}

