/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance;

import visualizer.projection.distance.CityBlock;
import visualizer.projection.distance.CosineBased;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.Euclidean;
import visualizer.projection.distance.ExtendedJaccard;
import visualizer.projection.distance.InfinityNorm;

public class DissimilarityFactory {
    public static Dissimilarity getInstance(DissimilarityType type) {
        if (type == DissimilarityType.CITY_BLOCK) {
            return new CityBlock();
        }
        if (type == DissimilarityType.COSINE_BASED) {
            return new CosineBased();
        }
        if (type == DissimilarityType.EUCLIDEAN) {
            return new Euclidean();
        }
        if (type == DissimilarityType.EXTENDED_JACCARD) {
            return new ExtendedJaccard();
        }
        if (type == DissimilarityType.INFINITY_NORM) {
            return new InfinityNorm();
        }
        return null;
    }
}

