/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.Matrix;
import visualizer.projection.GraphBuilder;
import visualizer.projection.distance.Dissimilarity;

public class DistanceMatrix
implements Cloneable {
    private ArrayList<String> ids;
    private float[] cdata;
    private float[][] distmatrix;
    private int nrElements;
    private float maxDistance;
    private float minDistance;

    public DistanceMatrix(String filename) throws IOException {
        this.load(filename);
    }

    public DistanceMatrix(int nrElements) {
        this.maxDistance = Float.NEGATIVE_INFINITY;
        this.minDistance = Float.POSITIVE_INFINITY;
        this.nrElements = nrElements;
        this.distmatrix = new float[nrElements - 1][];
        for (int i = 0; i < this.nrElements - 1; ++i) {
            this.distmatrix[i] = new float[i + 1];
        }
    }

    public DistanceMatrix(Matrix matrix, Dissimilarity diss) throws IOException {
        this.nrElements = matrix.getRowCount();
        this.maxDistance = Float.NEGATIVE_INFINITY;
        this.minDistance = Float.POSITIVE_INFINITY;
        this.distmatrix = new float[this.nrElements - 1][];
        for (int i = 0; i < this.nrElements - 1; ++i) {
            this.distmatrix[i] = new float[i + 1];
            for (int j = 0; j < this.distmatrix[i].length; ++j) {
                float distance = diss.calculate(matrix.getRow(i + 1), matrix.getRow(j));
                this.setDistance(i + 1, j, distance);
            }
        }
        this.ids = matrix.getIds();
        this.cdata = matrix.getClassData();
    }

    public void setDistance(int indexA, int indexB, float value) {
        assert (indexA >= 0 && indexA < this.nrElements && indexB >= 0 && indexB < this.nrElements) : "ERROR: index out of bounds!";
        if (indexA != indexB) {
            if (indexA < indexB) {
                this.distmatrix[indexB - 1][indexA] = value;
            } else {
                this.distmatrix[indexA - 1][indexB] = value;
            }
            if (this.minDistance > value && value >= 0.0f) {
                this.minDistance = value;
            } else if (this.maxDistance < value && value >= 0.0f) {
                this.maxDistance = value;
            }
        }
    }

    public float getDistance(int indexA, int indexB) {
        assert (indexA >= 0 && indexA < this.nrElements && indexB >= 0 && indexB < this.nrElements) : "ERROR: index out of bounds!";
        if (indexA == indexB) {
            return 0.0f;
        }
        if (indexA < indexB) {
            return this.distmatrix[indexB - 1][indexA];
        }
        return this.distmatrix[indexA - 1][indexB];
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public int getElementCount() {
        return this.nrElements;
    }

    public Object clone() throws CloneNotSupportedException {
        DistanceMatrix dmat = new DistanceMatrix(this.nrElements);
        dmat.maxDistance = this.maxDistance;
        dmat.minDistance = this.minDistance;
        for (int i = 0; i < this.distmatrix.length; ++i) {
            for (int j = 0; j < this.distmatrix[i].length; ++j) {
                dmat.distmatrix[i][j] = this.distmatrix[i][j];
            }
        }
        return dmat;
    }

    public void save(String filename) throws IOException {
        BufferedWriter out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(filename));
            out.write(Integer.toString(this.nrElements));
            out.write("\r\n");
            if (this.ids != null) {
                for (i = 0; i < this.ids.size() - 1; ++i) {
                    out.write(this.ids.get(i));
                    out.write(";");
                }
                out.write(this.ids.get(this.ids.size() - 1));
                out.write("\r\n");
            } else {
                for (i = 0; i < this.nrElements - 1; ++i) {
                    out.write(Integer.toString(i) + ";");
                }
                out.write(Integer.toString(this.nrElements - 1) + "\r\n");
            }
            if (this.cdata != null) {
                for (i = 0; i < this.cdata.length - 1; ++i) {
                    out.write(Float.toString(this.cdata[i]));
                    out.write(";");
                }
                out.write(Float.toString(this.cdata[this.cdata.length - 1]));
                out.write("\r\n");
            } else {
                for (i = 0; i < this.nrElements - 1; ++i) {
                    out.write("0;");
                }
                out.write("0\r\n");
            }
            for (i = 0; i < this.distmatrix.length; ++i) {
                for (int j = 0; j < this.distmatrix[i].length; ++j) {
                    out.write(Float.toString(this.distmatrix[i][j]));
                    if (j >= this.distmatrix[i].length - 1) continue;
                    out.write(";");
                }
                out.write("\r\n");
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void load(String filename) throws IOException {
        BufferedReader in = null;
        try {
            int i;
            in = new BufferedReader(new FileReader(filename));
            this.nrElements = Integer.parseInt(in.readLine());
            StringTokenizer tUrls = new StringTokenizer(in.readLine(), ";");
            this.ids = new ArrayList();
            while (tUrls.hasMoreTokens()) {
                this.ids.add(tUrls.nextToken().trim());
            }
            if (this.ids.size() != this.nrElements) {
                throw new IOException("The number of ids does not match with the size of matrix (" + this.ids.size() + " - " + this.nrElements + ").");
            }
            StringTokenizer tCdata = new StringTokenizer(in.readLine(), ";");
            ArrayList<Float> cdata_aux = new ArrayList<Float>();
            while (tCdata.hasMoreTokens()) {
                String token = tCdata.nextToken();
                cdata_aux.add(Float.valueOf(Float.parseFloat(token.trim())));
            }
            if (this.ids.size() != cdata_aux.size()) {
                throw new IOException("The number of class data items does not match with the size of matrix (" + this.ids.size() + " - " + this.nrElements + ").");
            }
            this.cdata = new float[cdata_aux.size()];
            for (i = 0; i < this.cdata.length; ++i) {
                this.cdata[i] = ((Float)cdata_aux.get(i)).floatValue();
            }
            this.maxDistance = Float.NEGATIVE_INFINITY;
            this.minDistance = Float.POSITIVE_INFINITY;
            this.distmatrix = new float[this.nrElements - 1][];
            for (i = 0; i < this.distmatrix.length; ++i) {
                this.distmatrix[i] = new float[i + 1];
            }
            for (i = 0; i < this.distmatrix.length; ++i) {
                String line = in.readLine();
                if (line != null) {
                    StringTokenizer tDistance = new StringTokenizer(line, ";");
                    for (int j = 0; j < this.distmatrix[i].length; ++j) {
                        if (!tDistance.hasMoreTokens()) {
                            throw new IOException("Wrong distance matrix file format.");
                        }
                        String token = tDistance.nextToken();
                        float dist = Float.parseFloat(token.trim());
                        this.setDistance(i + 1, j, dist);
                    }
                    continue;
                }
                throw new IOException("Wrong distance matrix file format.");
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(GraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public float[] getClassData() {
        return this.cdata;
    }

    public ArrayList<String> getIds() {
        return this.ids;
    }

    public void setClassData(float[] cdata) {
        this.cdata = cdata;
    }

    public void setIds(ArrayList<String> ids) {
        this.ids = ids;
    }
}

