/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance;

import java.io.IOException;
import visualizer.corpus.Corpus;
import visualizer.corpus.CorpusFactory;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.projection.ProjectionData;
import visualizer.projection.SourceType;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.kolmogorov.NcdDistanceMatrixFactory;
import visualizer.wizard.ProjectionView;

public class DistanceMatrixFactory {
    public static DistanceMatrix getInstance(ProjectionView view, ProjectionData pdata) throws IOException {
        DistanceMatrix dmat = null;
        if (pdata.getDissimilarityType() == DissimilarityType.KOLMOGOROV) {
            Corpus cp = CorpusFactory.getInstance(pdata.getSourceFile(), pdata);
            if (view != null) {
                view.setStatus("Calculating the distance matrix...", 0);
            }
            dmat = NcdDistanceMatrixFactory.getInstance(view, pdata.getCompressorType(), cp);
        } else if (pdata.getSourceType() == SourceType.DISTANCE_MATRIX) {
            if (view != null) {
                view.setStatus("Reading the distances from file...", 5);
            }
            dmat = new DistanceMatrix(pdata.getSourceFile());
        }
        return dmat;
    }

    public static DistanceMatrix getInstance(float[][] points, Dissimilarity diss) throws IOException {
        DenseMatrix matrix = new DenseMatrix();
        for (int i = 0; i < points.length; ++i) {
            ((Matrix)matrix).addRow(new DenseVector(points[i]));
        }
        return new DistanceMatrix(matrix, diss);
    }
}

