/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance;

import visualizer.matrix.DenseVector;
import visualizer.matrix.SparseVector;
import visualizer.matrix.Vector;
import visualizer.projection.distance.Dissimilarity;

public class InfinityNorm
implements Dissimilarity {
    @Override
    public float calculate(Vector v1, Vector v2) {
        assert (v1.size() == v2.size()) : "ERROR: vectors of different sizes!";
        assert (v1.getClass() == v2.getClass()) : "Error: only supported comparing vectors of the same type";
        if (v1 instanceof SparseVector) {
            float diff;
            if (((SparseVector)v2).getIndex().length > ((SparseVector)v1).getIndex().length) {
                SparseVector tmp = (SparseVector)v1;
                v1 = v2;
                v2 = tmp;
            }
            int v1length = ((SparseVector)v1).getIndex().length;
            int v2length = ((SparseVector)v2).getIndex().length;
            int[] v1index = ((SparseVector)v1).getIndex();
            int[] v2index = ((SparseVector)v2).getIndex();
            float[] v1values = v1.getValues();
            float[] v2values = v2.getValues();
            int i = 0;
            int j = 0;
            float dist = Float.NEGATIVE_INFINITY;
            while (i < v1length && j < v2length) {
                if (v1index[i] == v2index[j]) {
                    diff = Math.abs(v1values[i] - v2values[j]);
                    dist = diff > dist ? diff : dist;
                    ++i;
                    ++j;
                    continue;
                }
                if (v1index[i] < v2index[j]) {
                    diff = Math.abs(v1values[i]);
                    dist = diff > dist ? diff : dist;
                    ++i;
                    continue;
                }
                diff = Math.abs(v2values[j]);
                dist = diff > dist ? diff : dist;
                ++j;
            }
            while (i < v1length) {
                diff = Math.abs(v1values[i]);
                dist = diff > dist ? diff : dist;
                ++i;
            }
            while (j < v2length) {
                diff = Math.abs(v2values[j]);
                dist = diff > dist ? diff : dist;
                ++j;
            }
            return dist;
        }
        if (v1 instanceof DenseVector) {
            float[] vector1 = v1.getValues();
            float[] vector2 = v2.getValues();
            float dist = 0.0f;
            int length = vector1.length;
            for (int i = 0; i < length; ++i) {
                float diff = Math.abs(vector1[i] - vector2[i]);
                dist = diff > dist ? diff : dist;
            }
            return dist;
        }
        return 0.0f;
    }
}

