/*
 * Decompiled with CFR 0.152.
 */
package visualizer.textprocessing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.util.SystemPropertiesManager;

public class Stopword {
    private List<String> stopwords;
    private static Stopword instance;
    private String filename;

    private Stopword(String filename) throws IOException {
        this.readStopwordList(filename);
    }

    public static Stopword getInstance() throws IOException {
        if (instance == null) {
            SystemPropertiesManager m = SystemPropertiesManager.getInstance();
            String stpFilename = m.getProperty("SPW.FILE");
            File f = new File(stpFilename);
            if (!f.exists() || m.getProperty("SPW.FILE").trim().length() < 1) {
                stpFilename = "config/stopwords_eng.spw";
                m.setProperty("SPW.FILE", stpFilename);
            }
            instance = new Stopword(stpFilename);
        }
        return instance;
    }

    public void changeStopwordList(String stpFilename) throws IOException {
        this.readStopwordList(stpFilename);
    }

    public List<String> getStopwordList() {
        return this.stopwords;
    }

    public void addStopwords(List<String> stopwords) {
        for (String stopword : stopwords) {
            if (this.stopwords.contains(stopword.toLowerCase())) continue;
            this.stopwords.add(stopword.toLowerCase());
        }
        Collections.sort(this.stopwords);
    }

    public void removeStopword(String stopword) {
        this.stopwords.remove(stopword);
    }

    public void saveStopwordsList(String filename) throws IOException {
        this.filename = filename;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (String stopword : this.stopwords) {
                out.write(stopword);
                out.write("\n");
            }
        }
        catch (IOException ex) {
            throw new IOException("Problems saving \"" + filename + "\" file!");
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isStopWord(String word) {
        return Collections.binarySearch(this.stopwords, word) >= 0;
    }

    private void readStopwordList(String filename) throws IOException {
        this.filename = filename;
        BufferedReader in = null;
        this.stopwords = new ArrayList<String>();
        try {
            in = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null && line.trim().length() > 0) {
                this.stopwords.add(line.toLowerCase());
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        Collections.sort(this.stopwords);
    }
}

