/*
 * Decompiled with CFR 0.152.
 */
package visualizer.textprocessing.transformation;

import java.util.ArrayList;

public class MatrixTransformationType {
    public static final MatrixTransformationType TF_IDF;
    public static final MatrixTransformationType NTF_IDF;
    public static final MatrixTransformationType NTF;
    public static final MatrixTransformationType NONE;
    private static ArrayList<MatrixTransformationType> types;
    private String name;

    private MatrixTransformationType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<MatrixTransformationType> getTypes() {
        return types;
    }

    public static MatrixTransformationType retrieve(String name) {
        for (MatrixTransformationType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MatrixTransformationType other = (MatrixTransformationType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        TF_IDF = new MatrixTransformationType("TF-IDF");
        NTF_IDF = new MatrixTransformationType("NTF-IDF");
        NTF = new MatrixTransformationType("NTF");
        NONE = new MatrixTransformationType("NONE (TF)");
    }
}

