/*
 * Decompiled with CFR 0.152.
 */
package visualizer.tools.apriori;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import visualizer.tools.apriori.ItemSet;
import visualizer.tools.apriori.MyTreeNode;
import visualizer.tools.apriori.StemDescription;
import visualizer.tools.apriori.Transaction;

public class HashTree {
    private static final int TOP_LEVEL = 0;
    private static int stemNum = 3;
    private static int bucketSize = 3;
    StemDescription[] stemDescriptors;
    HashMap tree;
    List<Integer> itemsRef;
    String[] ngrams;

    public HashTree(int n, String[] ngrams) {
        ArrayList<Integer> itemsReference = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            itemsReference.add(new Integer(i));
        }
        this.itemsRef = itemsReference;
        this.tree = new HashMap();
        this.ngrams = ngrams;
        this.defineStems(this.itemsRef);
    }

    public HashTree(List<Integer> itemsReference) {
        this.itemsRef = itemsReference;
        this.tree = new HashMap();
        this.defineStems(this.itemsRef);
    }

    public void addCandidates(List<ItemSet> currentItemsets) {
        ListIterator<ItemSet> itItemsets = currentItemsets.listIterator(0);
        for (ItemSet currentItemset : currentItemsets) {
            int count;
            List<Integer> currentItemsetItems = currentItemset.getItems();
            Integer currentItem = currentItemsetItems.get(0);
            for (count = 0; count < this.stemDescriptors.length && !this.stemDescriptors[count].keyExists(currentItem); ++count) {
            }
            Character currentStemID = this.stemDescriptors[count].getID();
            if (this.tree.containsKey(currentStemID)) {
                ((MyTreeNode)this.tree.get(currentStemID)).addItemset(currentItemset);
                continue;
            }
            MyTreeNode newBucket = new MyTreeNode(bucketSize, stemNum, this.itemsRef, this.stemDescriptors, 1);
            newBucket.addItemset(currentItemset);
            this.tree.put(currentStemID, newBucket);
        }
    }

    public void defineStems(List<Integer> itemsRef) {
        int count;
        char stemIDcount = 'A';
        ListIterator<Integer> itItemsRef = itemsRef.listIterator(0);
        this.stemDescriptors = new StemDescription[stemNum];
        for (count = 0; count < stemNum; ++count) {
            Character stemID = new Character(stemIDcount);
            stemIDcount = (char)(stemIDcount + '\u0001');
            this.stemDescriptors[count] = new StemDescription(stemID);
        }
        int i = 0;
        while (i < itemsRef.size()) {
            for (count = 0; i < itemsRef.size() && count < stemNum; ++i, ++count) {
                this.stemDescriptors[count].addKey(itemsRef.get(i));
            }
        }
    }

    public void passTransactions(int level, float[][] selectedPoints) {
        ArrayList items = new ArrayList();
        Integer currentTransactionID = new Integer(0);
        ArrayList transItems = new ArrayList();
        for (int i = 0; i < selectedPoints.length; ++i) {
            Transaction newTrans = new Transaction(new Integer(i).toString(), selectedPoints[i]);
            for (int count = 0; count < this.stemDescriptors.length; ++count) {
                Character currentStemID = this.stemDescriptors[count].getID();
                if (!this.tree.containsKey(currentStemID)) continue;
                MyTreeNode currentNode = (MyTreeNode)this.tree.get(currentStemID);
                currentNode.passTransaction(newTrans, level);
            }
        }
    }

    public void removeInfrequentItemsets(float minSup) {
        for (int count = 0; count < this.stemDescriptors.length; ++count) {
            Character currentStemID = this.stemDescriptors[count].getID();
            if (!this.tree.containsKey(currentStemID)) continue;
            MyTreeNode currentNode = (MyTreeNode)this.tree.get(currentStemID);
            currentNode.removeInfrequentItemsets(minSup);
        }
    }

    public void printTree() {
        ArrayList treeContents = new ArrayList(this.tree.values());
        System.out.println("Printing tree\n******************************");
        System.out.println("tree size " + treeContents.size());
        for (int count = 0; count < treeContents.size(); ++count) {
            MyTreeNode currentNode = (MyTreeNode)treeContents.get(count);
            currentNode.printContents();
        }
    }

    public LinkedList getFrequentNItemsets(int n) {
        LinkedList fNItemsetsArray = new LinkedList();
        for (int count = 0; count < this.stemDescriptors.length; ++count) {
            Character currentStemID = this.stemDescriptors[count].getID();
            if (!this.tree.containsKey(currentStemID)) continue;
            MyTreeNode currentNode = (MyTreeNode)this.tree.get(currentStemID);
            fNItemsetsArray.addAll(currentNode.getItemsets(n));
        }
        return fNItemsetsArray;
    }

    public ArrayList getAllFrequentItemsets() {
        ArrayList fNItemsetsArray = new ArrayList();
        for (int count = 0; count < this.stemDescriptors.length; ++count) {
            Character currentStemID = this.stemDescriptors[count].getID();
            if (!this.tree.containsKey(currentStemID)) continue;
            MyTreeNode currentNode = (MyTreeNode)this.tree.get(currentStemID);
            fNItemsetsArray.addAll(currentNode.getAllItemsets());
        }
        return fNItemsetsArray;
    }

    public void printAllFrequentItemsets(int numberOfTransactions, float minSupPercentage) {
        System.out.println("Frequent itemsets:");
        ArrayList itemsets = this.getAllFrequentItemsets();
        for (int count = 0; count < itemsets.size(); ++count) {
            ItemSet currentItemset = (ItemSet)itemsets.get(count);
        }
    }

    public void printAllFrequentItemsets(String filename, int numberOfTransactions, int minSupPercentage) {
        PrintWriter outputStream = null;
        try {
            outputStream = new PrintWriter(new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening " + filename);
            System.exit(0);
        }
        ArrayList itemsets = this.getAllFrequentItemsets();
        for (int count = 0; count < itemsets.size(); ++count) {
            ItemSet currentItemset = (ItemSet)itemsets.get(count);
        }
        outputStream.close();
        System.out.println("--Frequent itemsets written to file.");
    }
}

