/*
 * Decompiled with CFR 0.152.
 */
package visualizer.tools.apriori;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.tools.apriori.HashTree;
import visualizer.tools.apriori.ItemSet;
import visualizer.tools.apriori.RuleSet;
import visualizer.topic.TopicData;

public class SelectedApriori {
    private float minSup;
    private float minConf;
    private float beta = 1.0f;
    private float[][] selectedPoints;
    float[][] allPoints;
    public boolean[] coveredPoints;
    private String[] ngrams;
    public String topic;
    private List<ItemSet> itemSets = null;
    private List<ItemSet> selectedItemSets = null;
    public String ruleDump = "";
    private TopicData.WeightType weightType = TopicData.WeightType.LOCAL;
    private List<RuleSet> ruleSetList;
    private Set<String> termSet = new HashSet<String>();
    private Set<String> termSetW = new HashSet<String>();
    private TopicData tdata;

    public SelectedApriori(float[][] selectedPoints, float[][] allPoints, Object[] ngrams) {
        this.selectedPoints = selectedPoints;
        this.allPoints = allPoints;
        this.ngrams = new String[ngrams.length];
        for (int i = 0; i < ngrams.length; ++i) {
            this.ngrams[i] = (String)ngrams[i];
        }
    }

    public void run() {
        int j;
        int i;
        int nTop = 10;
        this.ruleDump = "";
        this.outItemGlobal("head;\titem;\titem;\titem;\titem;\titem\t;item\t; sup(head)\t;abs(head)\t;sup(rule)\t;abs(rule)\t;sup(body)\t;abs(body)\t;conf;Run;Selection");
        float[] singleItemSupport = new float[this.selectedPoints[0].length];
        float[] singleItemTfIdf = new float[this.selectedPoints[0].length];
        float[] singleItemTfIdfSum = new float[this.selectedPoints[0].length];
        float[] newWeight = new float[this.selectedPoints[0].length];
        this.coveredPoints = new boolean[this.selectedPoints.length];
        for (int j2 = 0; j2 < this.selectedPoints.length; ++j2) {
            this.coveredPoints[j2] = false;
        }
        for (i = 0; i < this.allPoints[0].length; ++i) {
            singleItemTfIdfSum[i] = 0.0f;
            for (j = 0; j < this.allPoints.length; ++j) {
                int n = i;
                singleItemTfIdfSum[n] = singleItemTfIdfSum[n] + this.allPoints[j][i];
            }
        }
        for (i = 0; i < this.selectedPoints[0].length; ++i) {
            singleItemSupport[i] = 0.0f;
            singleItemTfIdf[i] = 0.0f;
            for (j = 0; j < this.selectedPoints.length; ++j) {
                int n = i;
                singleItemSupport[n] = singleItemSupport[n] + (float)(this.selectedPoints[j][i] > 0.0f ? 1 : 0);
                int n2 = i;
                singleItemTfIdf[n2] = singleItemTfIdf[n2] + this.selectedPoints[j][i];
            }
            singleItemTfIdf[i] = singleItemTfIdf[i] / singleItemTfIdfSum[i];
            newWeight[i] = singleItemTfIdf[i] * singleItemSupport[i] / (float)this.selectedPoints.length;
        }
        float practicalMinSup = this.tdata.getSupportType() == TopicData.SupportType.RELATIVE ? this.tdata.getMinSup() * (float)this.selectedPoints.length / 100.0f : (float)this.tdata.getMinSupAbs();
        long practicalMinSupInt = Math.round(practicalMinSup);
        if (practicalMinSupInt < 3L) {
            practicalMinSupInt = 3L;
        }
        ArrayList itemSets = null;
        do {
            float[] top = new float[nTop + 1];
            block6: for (int i2 = 0; i2 < this.selectedPoints[0].length; ++i2) {
                for (int l = 0; l < nTop; ++l) {
                    if (!(newWeight[i2] > top[l])) continue;
                    for (int m = nTop - 1; m >= l; --m) {
                        top[m + 1] = top[m];
                    }
                    top[l] = newWeight[i2];
                    continue block6;
                }
            }
            float practicalMinNewWeight = top[nTop - 1];
            float threshold = 1.0f * (float)this.selectedPoints.length / (float)this.allPoints.length;
            this.ruleDump = "Selection size:\t" + this.selectedPoints.length + "/" + (double)threshold * 100.0 + "%\n";
            this.ruleDump = this.ruleDump + "Top Locally Weighted Terms >=" + practicalMinNewWeight + "\n";
            ArrayList<ItemSet> frequentOneItemSets = new ArrayList<ItemSet>();
            ArrayList<ItemSet> topOneItemSets = new ArrayList<ItemSet>();
            for (int i3 = 0; i3 < singleItemSupport.length; ++i3) {
                ItemSet iS = new ItemSet();
                iS.setOneItem(new Integer(i3));
                if (singleItemSupport[i3] > (float)practicalMinSupInt && singleItemTfIdf[i3] >= threshold) {
                    frequentOneItemSets.add(iS);
                }
                if (!(newWeight[i3] >= practicalMinNewWeight)) continue;
                topOneItemSets.add(iS);
                this.ruleDump = this.ruleDump + this.ngrams[i3] + ", ";
            }
            HashTree tree = new HashTree(this.selectedPoints[0].length, this.ngrams);
            tree.addCandidates(frequentOneItemSets);
            List<ItemSet> currentItemSets = frequentOneItemSets;
            currentItemSets = this.generateNItemsets(topOneItemSets, currentItemSets, 1);
            tree.addCandidates(currentItemSets);
            tree.passTransactions(2, this.selectedPoints);
            tree.removeInfrequentItemsets(practicalMinSupInt);
            currentItemSets = tree.getFrequentNItemsets(2);
            int count = 2;
            while (currentItemSets.size() > 0 && currentItemSets.size() < 5000) {
                currentItemSets = this.generateNItemsets(frequentOneItemSets, currentItemSets, count);
                tree.addCandidates(currentItemSets);
                tree.passTransactions(count + 1, this.selectedPoints);
                tree.removeInfrequentItemsets(practicalMinSupInt);
                currentItemSets = tree.getFrequentNItemsets(count + 1);
                ++count;
            }
            itemSets = tree.getAllFrequentItemsets();
            this.selectedItemSets = new ArrayList<ItemSet>();
            System.out.println("Current Support:" + practicalMinSupInt);
            System.out.println("Item Set size:" + itemSets.size());
            if (itemSets.size() != 0) continue;
            float delta = practicalMinSup * 0.5f;
            System.out.println("delta:" + delta);
            if ((double)delta < 1.0) {
                delta = 1.0f;
            }
            practicalMinSupInt = Math.round(practicalMinSup -= delta);
            System.out.println("Novo Suporte:" + practicalMinSupInt);
            ++nTop;
        } while (itemSets.size() == 0 && practicalMinSupInt >= 3L);
        if (itemSets.size() > 0) {
            float[] maxWeight;
            int nTopic = 1;
            for (float d : maxWeight = new float[nTopic + 1]) {
                d = Float.NEGATIVE_INFINITY;
            }
            ItemSet[] maxItemSet = new ItemSet[nTopic + 1];
            for (int i4 = 0; i4 < itemSets.size(); ++i4) {
                ItemSet iS = (ItemSet)itemSets.get(i4);
                iS.compute(this.selectedPoints, singleItemTfIdf, singleItemSupport);
            }
            Collections.sort(itemSets);
            this.topic = "";
            int coverAnt = 0;
            this.ruleDump = this.ruleDump + "\n";
            for (int j3 = 0; j3 < itemSets.size(); ++j3) {
                float delta;
                int cover = 0;
                cover = ((ItemSet)itemSets.get(j3)).countCovered(this.selectedPoints, this.coveredPoints);
                if (!((float)cover > (delta = 0.0f))) continue;
                ((ItemSet)itemSets.get(j3)).computeConfidence(this.selectedPoints);
                ((ItemSet)itemSets.get(j3)).computeGlobal(this.allPoints);
                ((ItemSet)itemSets.get(j3)).setLdata(this.tdata);
                ((ItemSet)itemSets.get(j3)).computeRuleTopic(this.ngrams, singleItemTfIdf, this.selectedPoints.length);
                ((ItemSet)itemSets.get(j3)).computePhrase(this.allPoints, this.tdata, this.ngrams, singleItemTfIdf, this.selectedPoints.length);
                ((ItemSet)itemSets.get(j3)).computeShortPhrase(this.allPoints, this.tdata, this.ngrams, singleItemTfIdf, this.selectedPoints.length);
                cover = ((ItemSet)itemSets.get(j3)).setCovered(this.selectedPoints, this.coveredPoints, true);
                System.out.println("*****Selected:" + ((ItemSet)itemSets.get(j3)).toStringDump(this.ngrams, singleItemTfIdf, this.selectedPoints.length, singleItemSupport));
                String outGlobal = ((ItemSet)itemSets.get(j3)).toStringGlobal(this.ngrams, this.allPoints.length);
                this.outItemGlobal(outGlobal + ";" + this.tdata.getCurrentRun() + ";" + this.tdata.getCurrentSelection());
                System.out.println(outGlobal);
                coverAnt = cover;
                this.selectedItemSets.add((ItemSet)itemSets.get(j3));
                for (String term : ((ItemSet)itemSets.get(j3)).getTerms()) {
                    this.termSet.add(term);
                }
                for (Integer item : ((ItemSet)itemSets.get(j3)).getItems()) {
                    this.termSetW.add(this.ngrams[item] + " ; " + singleItemTfIdf[item]);
                }
                if (this.ruleSetList == null) continue;
                boolean join = false;
                boolean joinedOne = false;
                for (RuleSet rS : this.ruleSetList) {
                    join = false;
                    int overlap = ((ItemSet)itemSets.get(j3)).countOverlap(this.allPoints, rS.coveredPoints);
                    int support = Math.min(((ItemSet)itemSets.get(j3)).getSupport(), rS.getSupportGlobal());
                    int termOverlap = 0;
                    for (String term : ((ItemSet)itemSets.get(j3)).getTerms()) {
                        if (!rS.getTermSet().contains(term)) continue;
                        ++termOverlap;
                    }
                    double relTermOverlap = (double)termOverlap / (double)Math.min(((ItemSet)itemSets.get(j3)).getTerms().size(), rS.getTermSet().size());
                    double relOverlap = (double)overlap / (double)support;
                    if (relTermOverlap > 0.0 && relOverlap > 0.5) {
                        System.out.println("Joined:" + rS.toString() + ":D=" + relOverlap + ":T=" + relTermOverlap);
                        rS.add((ItemSet)itemSets.get(j3));
                        joinedOne = true;
                        continue;
                    }
                    System.out.println("Not Joined:" + rS.toString() + ":D=" + relOverlap + ":T=" + relTermOverlap);
                }
                System.out.println();
                if (joinedOne) continue;
                RuleSet rS = new RuleSet(this.allPoints);
                rS.add((ItemSet)itemSets.get(j3));
                this.ruleSetList.add(rS);
            }
            this.ruleDump = this.ruleDump + "\nRules:\t" + itemSets.size() + "\n";
            this.ruleDump = this.ruleDump + "Minimum Support:\t" + (double)practicalMinSupInt * 1.0 / (double)this.selectedPoints.length + "\n";
            this.ruleDump = this.ruleDump + "Top K Words:\t" + nTop + "\n";
        } else {
            this.topic = "";
        }
        this.itemSets = itemSets;
    }

    public float getMinSup() {
        return this.minSup;
    }

    public void setMinSup(float minSup) {
        this.minSup = minSup;
    }

    public float getMinConf() {
        return this.minConf;
    }

    public void setMinConf(float minConf) {
        this.minConf = minConf;
    }

    private List<ItemSet> generateNItemsets(List<ItemSet> oneItemsets, List<ItemSet> nMinusOneItemsets, int k) {
        ArrayList<ItemSet> nItemSets = new ArrayList<ItemSet>();
        for (ItemSet itemset : nMinusOneItemsets) {
            for (ItemSet oneItemset : oneItemsets) {
                ArrayList<Integer> newItemsetElements = new ArrayList<Integer>();
                List<Integer> oldItemSet = itemset.getItems();
                for (Integer oldItem : oldItemSet) {
                    newItemsetElements.add(oldItem);
                }
                if (oneItemset.getItem(0) <= (Integer)newItemsetElements.get(newItemsetElements.size() - 1)) continue;
                newItemsetElements.add(oneItemset.getItem(0));
                nItemSets.add(new ItemSet(newItemsetElements));
            }
        }
        return nItemSets;
    }

    private List<ItemSet> generateTopNItemsets(List<ItemSet> oneItemsets, List<ItemSet> nMinusOneItemsets, int k) {
        ArrayList<ItemSet> nItemSets = new ArrayList<ItemSet>();
        for (ItemSet itemset : nMinusOneItemsets) {
            for (ItemSet oneItemset : oneItemsets) {
                ArrayList<Integer> newItemsetElements = new ArrayList<Integer>();
                List<Integer> oldItemSet = itemset.getItems();
                for (Integer oldItem : oldItemSet) {
                    newItemsetElements.add(oldItem);
                }
                if (oneItemset.getItem(0) <= (Integer)newItemsetElements.get(newItemsetElements.size() - 1)) continue;
                newItemsetElements.add(oneItemset.getItem(0));
                nItemSets.add(new ItemSet(newItemsetElements));
            }
        }
        return nItemSets;
    }

    public List<ItemSet> getItemSets() {
        return this.itemSets;
    }

    public float getBeta() {
        return this.beta;
    }

    public void setBeta(float beta) {
        this.beta = beta;
    }

    private float getWeight(ItemSet iS) {
        if (this.weightType == TopicData.WeightType.LOCAL) {
            return this.beta * iS.getSumTfIdf() + (1.0f - this.beta) * iS.getSupportRelative();
        }
        return iS.getSumTfIdf() * iS.getSupportRelative() / (iS.getSumTfIdf() + iS.getSupportRelative());
    }

    private float getWeight(ItemSet iS, int n) {
        if (n == 0) {
            return iS.getSumTfIdf();
        }
        if (n == 1) {
            return iS.getSupportRelative();
        }
        return this.getWeight(iS);
    }

    public List<ItemSet> getSelectedItemSets() {
        return this.selectedItemSets;
    }

    public void setSelectedItemSets(List<ItemSet> selectedItemSets) {
        this.selectedItemSets = selectedItemSets;
    }

    private void outItem(ItemSet iS) {
        try {
            int i;
            PrintWriter out = new PrintWriter(new FileWriter("rulesDump.txt", true));
            int n = iS.getItems().size();
            for (i = 0; i < n; ++i) {
                out.print(iS.getItem(i) + "\t");
            }
            while (i < 20) {
                out.print("0\t");
                ++i;
            }
            out.println();
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void outItemGlobal(String itemTopic) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.tdata.getCsvFileName(), true));
            out.println(itemTopic);
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setRuleSetList(List ruleSetList) {
        this.ruleSetList = ruleSetList;
    }

    public TopicData getLdata() {
        return this.tdata;
    }

    public void setLdata(TopicData ldata) {
        this.tdata = ldata;
    }

    public Set<String> getTermSet() {
        return this.termSet;
    }

    public void setTermSet(Set<String> termSet) {
        this.termSet = termSet;
    }

    public Set<String> getTermSetW() {
        return this.termSetW;
    }

    public void setTermSetW(Set<String> termSetW) {
        this.termSetW = termSetW;
    }
}

