/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import visualizer.graph.Vertex;

public class StringBox {
    private String msg = "";
    private List<Vertex> relatedVertices;
    private Object userObject;
    private Rectangle rectangle;

    public StringBox(String msg) {
        this.msg = msg;
    }

    public StringBox(String msg, List<Vertex> relatedVertices) {
        this.msg = msg;
        this.relatedVertices = relatedVertices;
    }

    public StringBox(String msg, List<Vertex> relatedVertices, Object userObject) {
        this.msg = msg;
        this.relatedVertices = relatedVertices;
        this.userObject = userObject;
    }

    public Rectangle draw(Graphics g, Point position, Font font, boolean selected) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(font);
        FontMetrics metrics = g2.getFontMetrics(g2.getFont());
        int width = metrics.stringWidth(this.msg);
        int height = metrics.getAscent();
        Rectangle rect = new Rectangle(position.x - 2, position.y - 2, width + 4, height + 4);
        if (selected) {
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setPaint(Color.BLUE);
        } else {
            g2.setComposite(AlphaComposite.getInstance(3, 0.85f));
            g2.setPaint(new Color(255, 255, 204));
        }
        g2.drawRect(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
        g2.fill(rect);
        if (selected) {
            g2.setPaint(Color.WHITE);
        } else {
            g2.setPaint(Color.BLACK);
        }
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawRect(rect.x, rect.y, rect.width, rect.height);
        g2.drawString(this.msg, position.x, position.y + height - 2);
        this.rectangle = rect;
        return rect;
    }

    public String getMsg() {
        return this.msg;
    }

    public String toString() {
        return this.getMsg();
    }

    public List<Vertex> getRelatedVertices() {
        return this.relatedVertices;
    }

    public void setRelatedVertices(List<Vertex> relatedVertices) {
        this.relatedVertices = relatedVertices;
    }

    public boolean isInside(Point point) {
        return point.x > this.rectangle.x && point.x < this.rectangle.x + this.rectangle.width && point.y > this.rectangle.y && point.y < this.rectangle.y + this.rectangle.height;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }
}

