/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import visualizer.datamining.clustering.BKmeans;
import visualizer.datamining.clustering.Jdbscan2D;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.Euclidean;
import visualizer.topic.Topic;
import visualizer.topic.TopicData;
import visualizer.topic.TopicFactory;
import visualizer.util.OpenDialog;
import visualizer.view.Viewer;

public class TopicClusters {
    private Viewer gv;

    public TopicClusters(Viewer gv) {
        this.gv = gv;
    }

    public void execute(JFrame parent) throws IOException {
        int c;
        this.gv.getGraph().getTopicData().getTermSetRun().clear();
        this.gv.getGraph().getTopicData().getTermSetRunW().clear();
        this.gv.getGraph().addScalar("topics");
        DenseMatrix matrix = new DenseMatrix();
        for (int i = 0; i < this.gv.getGraph().getVertex().size(); ++i) {
            float[] point = new float[]{this.gv.getGraph().getVertex().get(i).getX(), this.gv.getGraph().getVertex().get(i).getY()};
            ((Matrix)matrix).addRow(new DenseVector(point));
        }
        ArrayList<ArrayList<Integer>> clusters = null;
        String scalarName = null;
        if (this.gv.getGraph().getTopicData().getClusteringType() == TopicData.ClusteringType.KMEANS) {
            String inputValue = (String)JOptionPane.showInputDialog(null, "Choose the number of clusters:", "Defining the Number of Clusters", 3, null, null, Integer.toString((int)Math.sqrt(this.gv.getGraph().getVertex().size())));
            if (inputValue == null) {
                return;
            }
            int nclusters = Integer.parseInt(inputValue);
            try {
                BKmeans km = new BKmeans(nclusters);
                clusters = km.execute(new Euclidean(), matrix);
                scalarName = "kmeans-" + clusters.size();
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            Jdbscan2D dbscan = new Jdbscan2D();
            clusters = dbscan.execute(new Euclidean(), matrix);
            scalarName = "dbscan-" + clusters.size();
        }
        Scalar s = this.gv.getGraph().addScalar(scalarName);
        for (c = 0; c < clusters.size(); ++c) {
            for (int v = 0; v < clusters.get(c).size(); ++v) {
                this.gv.getGraph().getVertex().get(clusters.get(c).get(v)).setScalar(s, c);
            }
        }
        if (OpenDialog.checkCorpus(this.gv.getGraph(), parent)) {
            for (c = 0; c < clusters.size(); ++c) {
                ArrayList<Vertex> vertex = new ArrayList<Vertex>();
                for (int v = 0; v < clusters.get(c).size(); ++v) {
                    vertex.add(this.gv.getGraph().getVertex().get(clusters.get(c).get(v)));
                }
                Topic topic = TopicFactory.getInstance(this.gv.getGraph(), this.gv.getGraph().getTopicData(), this.gv.getGraph().getCorpus(), vertex);
                this.gv.addTopic(topic);
            }
        }
        this.gv.updateScalars(this.gv.getGraph().getScalarByName("topics"));
        this.gv.updateImage();
    }
}

