/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.datamining.clustering.BKmeans;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.KNN;
import visualizer.util.Pair;

public class ApproxKNN {
    private int nrNeighbors = 5;

    public ApproxKNN(int nrNeighbors) {
        this.nrNeighbors = nrNeighbors;
    }

    public Pair[][] execute(Matrix matrix, Dissimilarity diss) throws IOException {
        BKmeans bkmeans = new BKmeans((int)Math.pow(matrix.getRowCount(), 0.5));
        ArrayList<ArrayList<Integer>> clusters = bkmeans.execute(diss, matrix);
        Matrix centroids = bkmeans.getCentroids();
        return this.execute(matrix, diss, clusters, centroids);
    }

    public Pair[][] execute(Matrix matrix, Dissimilarity diss, ArrayList<ArrayList<Integer>> clusters, Matrix centroids) throws IOException {
        long start = System.currentTimeMillis();
        if (this.nrNeighbors > matrix.getRowCount() - 1) {
            throw new IOException("Number of neighbors bigger than the number of elements minus one (an element is not computed as a neighbor of itself)!");
        }
        Pair[][] neighbors = null;
        neighbors = new Pair[matrix.getRowCount()][];
        for (int i = 0; i < neighbors.length; ++i) {
            neighbors[i] = new Pair[this.nrNeighbors];
            for (int j = 0; j < neighbors[i].length; ++j) {
                neighbors[i][j] = new Pair(-1, Float.MAX_VALUE);
            }
        }
        int nrClustersNeighbors = Math.max(5, (int)Math.sqrt(Math.sqrt(matrix.getRowCount())) * 3);
        nrClustersNeighbors = Math.min(nrClustersNeighbors, clusters.size() - 1);
        DistanceMatrix dmat_clusters = new DistanceMatrix(centroids, diss);
        KNN clustersKNN = new KNN(dmat_clusters.getElementCount() - 1);
        Pair[][] clustersNeighbors = clustersKNN.execute(dmat_clusters);
        for (int c = 0; c < clusters.size(); ++c) {
            for (int e = 0; e < clusters.get(c).size(); ++e) {
                int cn;
                int el = clusters.get(c).get(e);
                block4: for (int j = 0; j < clusters.get(c).size(); ++j) {
                    float dist;
                    int other = clusters.get(c).get(j);
                    if (el == other || !((dist = diss.calculate(matrix.getRow(el), matrix.getRow(other))) < neighbors[el][neighbors[el].length - 1].value)) continue;
                    for (int k = 0; k < neighbors[el].length; ++k) {
                        if (!(neighbors[el][k].value > dist)) continue;
                        for (int n = neighbors[el].length - 1; n > k; --n) {
                            neighbors[el][n].index = neighbors[el][n - 1].index;
                            neighbors[el][n].value = neighbors[el][n - 1].value;
                        }
                        neighbors[el][k].index = other;
                        neighbors[el][k].value = dist;
                        continue block4;
                    }
                }
                int nrtovisit = 1;
                int count = clusters.get(c).size() - 1;
                for (cn = 0; cn < clustersNeighbors[c].length && (count += clusters.get(clustersNeighbors[c][cn].index).size()) <= this.nrNeighbors; ++cn) {
                    ++nrtovisit;
                }
                nrtovisit = nrtovisit > nrClustersNeighbors ? nrtovisit : nrClustersNeighbors;
                for (cn = 0; cn < nrtovisit; ++cn) {
                    int clneighbor = clustersNeighbors[c][cn].index;
                    block9: for (int j = 0; j < clusters.get(clneighbor).size(); ++j) {
                        float dist;
                        int other = clusters.get(clneighbor).get(j);
                        if (el == other || !((dist = diss.calculate(matrix.getRow(el), matrix.getRow(other))) < neighbors[el][neighbors[el].length - 1].value)) continue;
                        for (int k = 0; k < neighbors[el].length; ++k) {
                            if (!(neighbors[el][k].value > dist)) continue;
                            for (int n = neighbors[el].length - 1; n > k; --n) {
                                neighbors[el][n].index = neighbors[el][n - 1].index;
                                neighbors[el][n].value = neighbors[el][n - 1].value;
                            }
                            neighbors[el][k].index = other;
                            neighbors[el][k].value = dist;
                            continue block9;
                        }
                    }
                }
            }
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Approximated KNN time: " + (float)(finish - start) / 1000.0f + "s");
        return neighbors;
    }
}

