/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.util.Pair;

public class Delaunay
implements Serializable {
    static float MIN_LINE_COS_ANGLE = 0.9986295f;
    int maximalNumberOfPoints = 1000;
    int maximalNumberOfFaces = 1000;
    float[] point = new float[3 * this.maximalNumberOfPoints];
    int[] face = new int[3 * this.maximalNumberOfFaces];
    int[] neighbor = new int[3 * this.maximalNumberOfFaces];
    boolean[] segment = new boolean[3 * this.maximalNumberOfFaces];
    int numberOfPoints;
    int numberOfFaces;
    float xyBound;
    boolean[] obsolete;
    boolean hasExteriorPoints = true;
    int[] newFace = new int[4];
    int[] newEdge = new int[4];
    int pointOnEdge;
    float circleX;
    float circleY;
    float circleR;
    private static final long serialVersionUID = 1L;

    public Delaunay() {
    }

    public Pair[][] execute(float[][] points) {
        int i;
        long start = System.currentTimeMillis();
        float[] dtpoints = new float[points.length * 2];
        for (int i2 = 0; i2 < dtpoints.length; i2 += 2) {
            dtpoints[i2] = points[i2 / 2][0];
            dtpoints[i2 + 1] = points[i2 / 2][1];
        }
        int[] ed = Delaunay.triangulate(dtpoints);
        ArrayList neigh_aux = new ArrayList();
        for (i = 0; i < points.length; ++i) {
            neigh_aux.add(new ArrayList());
        }
        for (i = 0; i < ed.length; ++i) {
            long v1 = ed[i++] - 3;
            long v2 = ed[i++] - 3;
            long v3 = ed[i] - 3;
            ((ArrayList)neigh_aux.get((int)v1)).add(new Pair((int)v2, -1.0f));
            ((ArrayList)neigh_aux.get((int)v1)).add(new Pair((int)v3, -1.0f));
            ((ArrayList)neigh_aux.get((int)v2)).add(new Pair((int)v3, -1.0f));
        }
        Pair[][] neighborhood = new Pair[points.length][];
        for (int i3 = 0; i3 < neigh_aux.size(); ++i3) {
            neighborhood[i3] = new Pair[((ArrayList)neigh_aux.get(i3)).size()];
            for (int j = 0; j < ((ArrayList)neigh_aux.get(i3)).size(); ++j) {
                neighborhood[i3][j] = (Pair)((ArrayList)neigh_aux.get(i3)).get(j);
            }
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Delaunay time: " + (float)(finish - start) / 1000.0f + "s");
        return neighborhood;
    }

    private Delaunay(float[] p) {
        this.init(p);
        this.eatExterior();
    }

    private Delaunay(float[][] p) {
        this.init(Delaunay.makePointArray(p));
        this.checkBoundary(p);
        this.makeSegments(p);
        this.eatExterior(p);
    }

    public static int[] triangulate(float[] p) {
        return new Delaunay(p).getIndices();
    }

    public float getBound() {
        return this.xyBound;
    }

    public int[] getIndices() {
        int[] r = new int[3 * this.numberOfFaces];
        System.arraycopy(this.face, 0, r, 0, 3 * this.numberOfFaces);
        return r;
    }

    public void getPoint(int index, float[] point) {
        if (point == null) {
            throw new RuntimeException("no array submitted");
        }
        if (point.length < 2) {
            throw new RuntimeException("submitted array is to small");
        }
        point[0] = this.point[2 * index];
        point[1] = this.point[2 * index + 1];
    }

    public void getPoints(float[] points, int offset) {
        if (points == null) {
            throw new RuntimeException("no array submitted");
        }
        if (this.point.length < 2 * this.numberOfPoints + offset) {
            throw new RuntimeException("submitted array is to small");
        }
        System.arraycopy(this.point, 0, points, offset, 2 * this.numberOfPoints);
    }

    public float[] getPoints() {
        float[] r = new float[2 * this.numberOfPoints];
        this.getPoints(r, 0);
        return r;
    }

    public int getNumFaces() {
        return this.numberOfFaces;
    }

    public int getNumPoints() {
        return this.numberOfPoints;
    }

    void init(float[] p) {
        int i;
        int nip = p.length / 2;
        this.xyBound = Math.abs(p[0]);
        for (i = 1; i < 2 * nip; ++i) {
            float f;
            float r = Math.abs(p[i]);
            if (!(f > this.xyBound)) continue;
            this.xyBound = r;
        }
        if (this.xyBound == 0.0f) {
            this.xyBound = 1.0f;
        }
        this.numberOfPoints = 3;
        this.point[0] = 3.0f * this.xyBound;
        this.point[1] = 0.0f;
        this.point[2] = 0.0f;
        this.point[3] = 3.0f * this.xyBound;
        this.point[4] = -3.0f * this.xyBound;
        this.point[5] = -3.0f * this.xyBound;
        this.numberOfFaces = 1;
        this.face[0] = 0;
        this.face[1] = 1;
        this.face[2] = 2;
        this.neighbor[0] = -1;
        this.neighbor[1] = -1;
        this.neighbor[2] = -1;
        i = 0;
        int c = 0;
        while (i < nip) {
            this.addPoint(p[c], p[c + 1]);
            ++i;
            c += 2;
        }
    }

    public void addPoint(float x, float y) {
        int f = this.findTriangle(x, y);
        if (f < 0) {
            throw new RuntimeException("point in no face");
        }
        if (this.pointOnEdge < 0) {
            this.addPoint(x, y, f);
        } else {
            this.addPoint(x, y, f, this.pointOnEdge);
        }
    }

    void addPoint(float x, float y, int f) {
        this.checkPointArray();
        this.point[2 * this.numberOfPoints] = x;
        this.point[2 * this.numberOfPoints + 1] = y;
        ++this.numberOfPoints;
        this.splitTriangle(f);
        this.legalizeNewFaces();
    }

    void addPoint(float x, float y, int f, int e) {
        this.checkPointArray();
        this.point[2 * this.numberOfPoints] = x;
        this.point[2 * this.numberOfPoints + 1] = y;
        ++this.numberOfPoints;
        this.splitEdge(f, e);
        this.legalizeNewFaces();
    }

    void legalizeNewFaces() {
        int f0 = this.newFace[0];
        int f1 = this.newFace[1];
        int f2 = this.newFace[2];
        int f3 = this.newFace[3];
        int e0 = this.newEdge[0];
        int e1 = this.newEdge[1];
        int e2 = this.newEdge[2];
        int e3 = this.newEdge[3];
        this.legalizeEdge(f0, e0);
        this.legalizeEdge(f1, e1);
        if (f2 >= 0) {
            this.legalizeEdge(f2, e2);
        }
        if (f3 >= 0) {
            this.legalizeEdge(f3, e3);
        }
    }

    int flipEdge(int f, int e) {
        int fp = 3 * f;
        int f2 = fp + (e + 2) % 3;
        int n = this.neighbor[fp + e];
        int np = 3 * n;
        int ne = this.getNeighbor(n, f);
        int n2 = np + (ne + 2) % 3;
        this.face[fp + (e + 1) % 3] = this.face[np + ne];
        this.face[np + (ne + 1) % 3] = this.face[fp + e];
        int dummy = this.neighbor[n2];
        if (dummy >= 0) {
            this.replaceNeighbor(dummy, n, f);
        }
        this.neighbor[fp + e] = dummy;
        dummy = this.neighbor[f2];
        if (dummy >= 0) {
            this.replaceNeighbor(dummy, f, n);
        }
        this.neighbor[np + ne] = dummy;
        this.neighbor[f2] = n;
        this.neighbor[n2] = f;
        return (ne + 1) % 3;
    }

    int findTriangle(float x, float y) {
        int i = 0;
        int fp = 0;
        while (i < this.numberOfFaces) {
            if (this.checkTriangle(i, x, y)) {
                return i;
            }
            ++i;
            fp += 3;
        }
        return -1;
    }

    boolean checkTriangle(int f, float x, float y) {
        int fp = 3 * f;
        int p0 = 2 * this.face[fp++];
        int p1 = 2 * this.face[fp++];
        int p2 = 2 * this.face[fp];
        float x0 = this.point[p0++];
        float y0 = this.point[p0];
        float x1 = this.point[p1++];
        float y1 = this.point[p1];
        float x2 = this.point[p2++];
        float y2 = this.point[p2];
        float e0x = x2 - x1;
        float e0y = y2 - y1;
        float e1x = x0 - x2;
        float e1y = y0 - y2;
        float e2x = x1 - x0;
        float e2y = y1 - y0;
        float v0x = x - x1;
        float v0y = y - y1;
        float v1x = x - x2;
        float v1y = y - y2;
        float v2x = x - x0;
        float v2y = y - y0;
        float n0 = e0x * v0y - e0y * v0x;
        float n1 = e1x * v1y - e1y * v1x;
        float n2 = e2x * v2y - e2y * v2x;
        if (n0 < 0.0f || n1 < 0.0f || n2 < 0.0f) {
            return false;
        }
        this.pointOnEdge = -1;
        float v0 = v0x * v0x + v0y * v0y;
        float v1 = v1x * v1x + v1y * v1y;
        float v2 = v2x * v2x + v2y * v2y;
        float e0 = e0x * e0x + e0y * e0y;
        float e1 = e1x * e1x + e1y * e1y;
        float e2 = e2x * e2x + e2y * e2y;
        float s0 = e0x * v0x + e0y * v0y;
        float s1 = e1x * v1x + e1y * v1y;
        float s2 = e2x * v2x + e2y * v2y;
        float cos0 = (float)((double)s0 / Math.sqrt(e0 * v0));
        float cos1 = (float)((double)s1 / Math.sqrt(e1 * v1));
        float cos2 = (float)((double)s2 / Math.sqrt(e2 * v2));
        if (cos0 > cos1) {
            if (cos0 > cos2) {
                if (cos0 >= MIN_LINE_COS_ANGLE) {
                    this.pointOnEdge = this.checkForNewEdges(x1, y1, x2, y2, x, y, f, 0);
                }
            } else if (cos2 >= MIN_LINE_COS_ANGLE) {
                this.pointOnEdge = this.checkForNewEdges(x0, y0, x1, y1, x, y, f, 2);
            }
        } else if (cos1 > cos2) {
            if (cos1 > MIN_LINE_COS_ANGLE) {
                this.pointOnEdge = this.checkForNewEdges(x2, y2, x0, y0, x, y, f, 1);
            }
        } else if (cos2 >= MIN_LINE_COS_ANGLE) {
            this.pointOnEdge = this.checkForNewEdges(x0, y0, x1, y1, x, y, f, 2);
        }
        return true;
    }

    int checkForNewEdges(float x1, float y1, float x2, float y2, float x, float y, int f, int e) {
        int n = this.neighbor[3 * f + e];
        if (n < 0) {
            return e;
        }
        int p = 2 * this.face[this.getNeighborPtr(n, f)];
        float x0 = this.point[p++];
        float y0 = this.point[p];
        float ex = x - x0;
        float ey = y - y0;
        float ex1 = x1 - x0;
        float ey1 = y1 - y0;
        float ex2 = x2 - x0;
        float ey2 = y2 - y0;
        if (ex * ey1 - ey * ex1 > 0.0f && ex2 * ey - ey2 * ex > 0.0f) {
            return e;
        }
        return -1;
    }

    void splitTriangle(int f) {
        this.checkFaceArray();
        int fp = 3 * f;
        int c = 3 * this.numberOfFaces;
        int n0 = this.neighbor[fp];
        int v0 = this.face[fp++];
        int n1 = this.neighbor[fp];
        int v1 = this.face[fp++];
        int n2 = this.neighbor[fp];
        int v2 = this.face[fp];
        if (n0 >= 0) {
            this.replaceNeighbor(n0, f, this.numberOfFaces + 1);
        }
        if (n2 >= 0) {
            this.replaceNeighbor(n2, f, this.numberOfFaces);
        }
        fp = 3 * f;
        this.neighbor[fp++] = this.numberOfFaces + 1;
        this.face[fp++] = this.numberOfPoints - 1;
        this.neighbor[fp] = this.numberOfFaces;
        this.neighbor[c] = this.numberOfFaces + 1;
        this.face[c++] = v0;
        this.neighbor[c] = f;
        this.face[c++] = v1;
        this.neighbor[c] = n2;
        this.face[c++] = this.numberOfPoints - 1;
        this.neighbor[c] = f;
        this.face[c++] = v1;
        this.neighbor[c] = this.numberOfFaces;
        this.face[c++] = v2;
        this.neighbor[c] = n0;
        this.face[c++] = this.numberOfPoints - 1;
        this.newFace[0] = f;
        this.newFace[1] = this.numberOfFaces;
        this.newFace[2] = this.numberOfFaces + 1;
        this.newFace[3] = -1;
        this.newEdge[0] = 1;
        this.newEdge[1] = 2;
        this.newEdge[2] = 2;
        this.numberOfFaces += 2;
    }

    void splitEdge(int f, int e) {
        this.checkFaceArray();
        int fp = 3 * f;
        int c = 3 * this.numberOfFaces;
        int f0 = fp + e;
        int f1 = fp + (e + 1) % 3;
        int f2 = fp + (e + 2) % 3;
        int n = this.neighbor[f0];
        int v0 = this.face[f0];
        int v1 = this.face[f1];
        int nf = this.neighbor[f2];
        if (nf >= 0) {
            this.replaceNeighbor(nf, f, this.numberOfFaces);
        }
        this.face[f1] = this.numberOfPoints - 1;
        this.neighbor[f2] = this.numberOfFaces;
        this.face[c++] = v0;
        this.neighbor[c] = f;
        this.face[c++] = v1;
        this.neighbor[c] = nf;
        this.face[c++] = this.numberOfPoints - 1;
        this.newFace[0] = f;
        this.newEdge[0] = (e + 1) % 3;
        this.newFace[1] = this.numberOfFaces;
        this.newEdge[1] = 2;
        if (n >= 0) {
            this.neighbor[3 * this.numberOfFaces] = this.numberOfFaces + 1;
            int np = 3 * n;
            int ne = this.getNeighbor(n, f);
            int n0 = np + ne;
            int n1 = np + (ne + 1) % 3;
            int n2 = np + (ne + 2) % 3;
            int nn = this.neighbor[n1];
            int v2 = this.face[n0];
            if (nn >= 0) {
                this.replaceNeighbor(nn, n, this.numberOfFaces + 1);
            }
            this.face[n2] = this.numberOfPoints - 1;
            this.neighbor[n1] = this.numberOfFaces + 1;
            this.neighbor[c] = n;
            this.face[c++] = v1;
            this.neighbor[c] = this.numberOfFaces;
            this.face[c++] = v2;
            this.neighbor[c] = nn;
            this.face[c] = this.numberOfPoints - 1;
            this.newFace[2] = n;
            this.newEdge[2] = (ne + 2) % 3;
            this.newFace[3] = this.numberOfFaces + 1;
            this.newEdge[3] = 2;
            this.numberOfFaces += 2;
        } else {
            this.neighbor[3 * this.numberOfFaces] = -1;
            this.newFace[2] = -1;
            this.newFace[3] = -1;
            ++this.numberOfFaces;
        }
    }

    void replaceNeighbor(int f, int n, int r) {
        this.neighbor[this.getNeighborPtr((int)f, (int)n)] = r;
    }

    int getNeighborPtr(int f, int n) {
        int fp = 3 * f - 1;
        for (int i = 0; i < 3; ++i) {
            if (this.neighbor[++fp] != n) continue;
            return fp;
        }
        throw new IllegalArgumentException(n + " is not a neighbor of " + f);
    }

    int getNeighbor(int f, int n) {
        int fp = 3 * f;
        for (int i = 0; i < 3; ++i) {
            if (this.neighbor[fp++] != n) continue;
            return i;
        }
        throw new IllegalArgumentException(n + " is not a neighbor of " + f);
    }

    boolean edgeIllegal(int f, int e) {
        int np;
        if (this.hasExteriorPoints) {
            int fp = 3 * f;
            int n = this.neighbor[fp + e];
            if (n < 0) {
                return false;
            }
            int v0 = this.face[fp + e];
            int v1 = this.face[fp + (e + 1) % 3];
            int v2 = this.face[fp + (e + 2) % 3];
            int v = this.face[this.getNeighborPtr(n, f)];
            if (v0 == 0 || v == 0) {
                return false;
            }
            if (v0 == 1 || v == 1) {
                return false;
            }
            if (v0 == 2 || v == 2) {
                return false;
            }
            np = 2 * v;
        } else {
            int fp = 3 * f + 3;
            if (this.segment[fp]) {
                return false;
            }
            int n = this.neighbor[fp];
            if (n < 0) {
                return false;
            }
            np = 2 * this.face[this.getNeighborPtr(n, f)];
        }
        return this.pointInCircle(this.point[np++], this.point[np], f);
    }

    void computeCircumCircle(float x0, float y0, float x1, float y1, float x2, float y2) {
        float ex = x1 - x0;
        float ey = y1 - y0;
        float nx = y2 - y1;
        float ny = x1 - x2;
        this.circleX = (x1 + x2) * 0.5f;
        this.circleY = (y1 + y2) * 0.5f;
        float dx = (x0 - x2) * 0.5f;
        float dy = (y0 - y2) * 0.5f;
        float s = (ex * dx + ey * dy) / (ex * nx + ey * ny);
        this.circleX += s * nx;
        this.circleY += s * ny;
        float rx = x0 - this.circleX;
        float ry = y0 - this.circleY;
        this.circleR = rx * rx + ry * ry;
    }

    void computeCircumCircle(int f) {
        int fp = 3 * f;
        int p0 = 2 * this.face[fp++];
        int p1 = 2 * this.face[fp++];
        int p2 = 2 * this.face[fp];
        this.computeCircumCircle(this.point[p0++], this.point[p0], this.point[p1++], this.point[p1], this.point[p2++], this.point[p2]);
    }

    boolean pointInCircle(float x, float y, int f) {
        this.computeCircumCircle(f);
        float dx = x - this.circleX;
        float dy = y - this.circleY;
        return dx * dx + dy * dy < this.circleR;
    }

    void legalizeEdge(int f, int e) {
        if (this.edgeIllegal(f, e)) {
            int n = this.neighbor[3 * f + e];
            int ne = this.flipEdge(f, e);
            this.legalizeEdge(f, e);
            this.legalizeEdge(n, ne);
        }
    }

    void checkPointArray() {
        if (this.numberOfPoints >= this.maximalNumberOfPoints - 1) {
            this.point = this.floatSize(this.point);
            this.maximalNumberOfPoints *= 2;
        }
    }

    void checkFaceArray() {
        if (this.numberOfFaces >= this.maximalNumberOfFaces - 4) {
            this.face = this.floatSize(this.face);
            this.neighbor = this.floatSize(this.neighbor);
            this.segment = this.floatSize(this.segment);
            this.maximalNumberOfFaces *= 2;
        }
    }

    float[] floatSize(float[] p) {
        int i = p.length;
        float[] newP = new float[2 * i];
        System.arraycopy(p, 0, newP, 0, i);
        return newP;
    }

    int[] floatSize(int[] p) {
        int i = p.length;
        int[] newP = new int[2 * i];
        System.arraycopy(p, 0, newP, 0, i);
        return newP;
    }

    boolean[] floatSize(boolean[] p) {
        int i = p.length;
        boolean[] newP = new boolean[2 * i];
        System.arraycopy(p, 0, newP, 0, i);
        return newP;
    }

    int pointInFace(int f, int v) {
        int fp = 3 * f;
        for (int i = 0; i < 3; ++i) {
            if (this.face[fp++] != v) continue;
            return i;
        }
        return -1;
    }

    int edgeInFace(int f, int v1, int v2) {
        int i = this.pointInFace(f, v1);
        int j = this.pointInFace(f, v2);
        if (i < 0 || j < 0) {
            return -1;
        }
        return 3 - i - j;
    }

    void eatExterior() {
        this.obsolete = new boolean[this.numberOfFaces];
        int i = 0;
        while (i < this.numberOfFaces) {
            this.obsolete[i++] = false;
        }
        int fp = 0;
        for (i = 0; i < this.numberOfFaces; ++i) {
            int j = 0;
            while (j < 3) {
                int v = this.face[fp];
                if (v == 0 || v == 1 || v == 2) {
                    this.obsolete[i] = true;
                }
                ++j;
                ++fp;
            }
        }
        this.deleteObsoleteFaces();
        this.hasExteriorPoints = false;
    }

    void deleteObsoleteFaces() {
        int i;
        int[] faceIndex = new int[this.numberOfFaces];
        int newNof = 0;
        for (i = 0; i < this.numberOfFaces; ++i) {
            faceIndex[i] = this.obsolete[i] ? -1 : newNof++;
        }
        int p0 = 0;
        int p1 = 0;
        for (i = 0; i < this.numberOfFaces; ++i) {
            if (this.obsolete[i]) {
                p0 += 3;
                continue;
            }
            System.arraycopy(this.face, p0, this.face, p1, 3);
            System.arraycopy(this.segment, p0, this.segment, p1, 3);
            int j = 0;
            while (j < 3) {
                int n;
                this.neighbor[p1] = (n = this.neighbor[p0++]) < 0 ? -1 : faceIndex[n];
                ++j;
                ++p1;
            }
        }
        this.numberOfFaces = newNof;
    }

    void shiftPoints() {
        int p0 = 3 * this.numberOfFaces;
        int i = 0;
        while (i < p0) {
            int n = i++;
            this.face[n] = this.face[n] - 3;
        }
        int p1 = 3 * this.numberOfPoints - 6;
        System.arraycopy(this.point, 6, this.point, 0, p1);
        this.numberOfPoints -= 3;
    }

    static float[] makePointArray(float[][] p) {
        int pp = 0;
        int nos = p.length;
        for (int i = 0; i < nos; ++i) {
            pp += p[i].length;
        }
        float[] r = new float[pp];
        int j = 0;
        for (int i = 0; i < nos; ++i) {
            int l = p[i].length;
            if (l % 2 == 1) {
                throw new RuntimeException("points need to be 2-dimensional");
            }
            System.arraycopy(p[i], 0, r, j, l);
            j += l;
        }
        return r;
    }

    void makeSegments(float[][] p) {
        int nos = p.length;
        int j = 3;
        for (int i = 0; i < nos; ++i) {
            int l = p[i].length / 2;
            for (int k = 0; k < l - 1; ++k) {
                this.seekSegment(j + k, j + k + 1);
            }
            if (l > 1) {
                this.seekSegment(j, j + l - 1);
            }
            j += l;
        }
    }

    boolean markSegment(int f, int e) {
        int fp = 3 * f + e;
        int n = this.neighbor[fp];
        if (n >= 0) {
            this.segment[this.getNeighborPtr((int)n, (int)f)] = true;
        }
        this.segment[fp] = true;
        return true;
    }

    boolean seekAndMarkSegment(int v0, int v1) {
        int i = 0;
        int fp = 0;
        while (i < this.numberOfFaces) {
            if (this.face[fp] == v0) {
                if (this.face[fp + 1] == v1) {
                    return this.markSegment(i, 2);
                }
                if (this.face[fp + 2] == v1) {
                    return this.markSegment(i, 1);
                }
            }
            if (this.face[fp + 1] == v0) {
                if (this.face[fp] == v1) {
                    return this.markSegment(i, 2);
                }
                if (this.face[fp + 2] == v1) {
                    return this.markSegment(i, 0);
                }
            }
            if (this.face[fp + 2] == v0) {
                if (this.face[fp] == v1) {
                    return this.markSegment(i, 1);
                }
                if (this.face[fp + 1] == v1) {
                    return this.markSegment(i, 0);
                }
            }
            ++i;
            fp += 3;
        }
        return false;
    }

    void seekSegment(int v0, int v1) {
        if (!this.seekAndMarkSegment(v0, v1)) {
            int v2 = this.numberOfPoints;
            int p0 = 2 * v0;
            int p1 = 2 * v1;
            this.addPoint(0.5f * (this.point[p0++] + this.point[p1++]), 0.5f * (this.point[p0] + this.point[p1]));
            this.seekSegment(v0, v2);
            this.seekSegment(v1, v2);
        }
    }

    void eatExterior(float[][] p) {
        this.obsolete = new boolean[this.numberOfFaces];
        int i = 0;
        while (i < this.numberOfFaces) {
            this.obsolete[i++] = false;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            int f = 0;
            int fp = 0;
            while (this.face[fp++] != i2 && this.face[fp++] != i2 && this.face[fp++] != i2) {
                ++f;
            }
            if (f >= this.numberOfFaces) continue;
            this.eatFace(f);
        }
        int nos = p.length;
        for (int i3 = 1; i3 < nos; ++i3) {
            if (!this.computeInteriorPoint(p[i3])) continue;
            this.eatFace(this.findTriangle(this.circleX, this.circleY));
        }
        this.deleteObsoleteFaces();
        this.shiftPoints();
        this.hasExteriorPoints = false;
    }

    boolean computeInteriorPoint(float[] p) {
        float x;
        float x0 = p[0];
        int j = 0;
        int l = p.length / 2;
        int i = 1;
        int c = 2;
        while (i < l) {
            float f;
            x = p[c];
            if (f > x0) {
                x0 = x;
                j = i;
            }
            ++i;
            c += 2;
        }
        int p1 = 2 * ((j + 1) % l);
        float y0 = p[2 * j + 1];
        float ym1 = p[p1 + 1] - y0;
        int p2 = 2 * ((j - 1 + l) % l);
        float ym2 = p[p2 + 1] - y0;
        if (ym1 * ym2 >= 0.0f) {
            if (ym1 == 0.0f && ym2 == 0.0f) {
                return false;
            }
            x = 1.0f;
            int c2 = 0;
            for (int i2 = 0; i2 < l; ++i2) {
                if (i2 != j) {
                    float xm = p[c2++] - x0;
                    int n = c2++;
                    float ym = p[n] - y0;
                    float xc = xm * xm + ym * ym;
                    if (!(xc < x)) continue;
                    x = xc;
                    continue;
                }
                c2 += 2;
            }
            float vx = p[p1++] + p[p2++] - 2.0f * x0;
            float vy = p[p1] + p[p2] - 2.0f * y0;
            float s = (float)(0.5 * Math.sqrt(x / (vx * vx + vy * vy)));
            this.circleX = x0 + s * vx;
            this.circleY = y0 + s * vy;
            return true;
        }
        x = x0 - 1.0f;
        for (int i3 = 0; i3 < l; ++i3) {
            float xc;
            if (j == i3 || j == (i3 + 1) % l) continue;
            p1 = 2 * i3;
            p2 = 2 * ((i3 + 1) % l);
            float x1 = p[p1++];
            float y1 = p[p1];
            float x2 = p[p2++];
            float y2 = p[p2];
            if (!((y2 - y0) * (y1 - y0) <= 0.0f) || !((xc = y1 == y2 ? (x1 > x2 ? x1 : x2) : x2 - (x2 - x1) * (y2 - y0) / (y2 - y1)) > x)) continue;
            x = xc;
        }
        if (x == x0) {
            return false;
        }
        this.circleX = 0.5f * (x + x0);
        this.circleY = y0;
        return true;
    }

    void eatFace(int f) {
        this.obsolete[f] = true;
        int fp = 3 * f;
        int n0 = this.neighbor[fp];
        int n1 = this.neighbor[fp + 1];
        int n2 = this.neighbor[fp + 2];
        boolean s0 = this.segment[fp++];
        boolean s1 = this.segment[fp++];
        boolean s2 = this.segment[fp++];
        if (!s0 && n0 >= 0 && !this.obsolete[n0]) {
            this.eatFace(n0);
        }
        if (!s1 && n1 >= 0 && !this.obsolete[n1]) {
            this.eatFace(n1);
        }
        if (!s2 && n2 >= 0 && !this.obsolete[n2]) {
            this.eatFace(n2);
        }
    }

    void checkBoundary(float[][] p) {
        int numberOfBoundaryCurves = p.length;
        for (int i = 0; i < numberOfBoundaryCurves; ++i) {
            int currentCurveLength = p[i].length / 2;
            for (int j = 0; j < currentCurveLength; ++j) {
                float e0x0 = p[i][2 * j];
                float e0y0 = p[i][2 * j + 1];
                float e0x1 = p[i][2 * ((j + 1) % currentCurveLength)];
                float e0y1 = p[i][2 * ((j + 1) % currentCurveLength) + 1];
                if (j < currentCurveLength - 2) {
                    for (int k = j + 2; k < currentCurveLength && (k != currentCurveLength || j != 0); ++k) {
                        if (!this.edgesCross(e0x0, e0y0, e0x1, e0y1, p[i][2 * k], p[i][2 * k + 1], p[i][2 * ((k + 1) % currentCurveLength)], p[i][2 * ((k + 1) % currentCurveLength) + 1])) continue;
                        throw new RuntimeException("boundary semengts must not intersect !");
                    }
                }
                if (i >= numberOfBoundaryCurves - 1) continue;
                int nextCurveLength = p[i + 1].length / 2;
                for (int k = 0; k < nextCurveLength; ++k) {
                    if (!this.edgesCross(e0x0, e0y0, e0x1, e0y1, p[i + 1][2 * k], p[i + 1][2 * k + 1], p[i + 1][2 * ((k + 1) % nextCurveLength)], p[i + 1][2 * ((k + 1) % nextCurveLength) + 1])) continue;
                    throw new RuntimeException("boundary semengts must not intersect !");
                }
            }
        }
    }

    boolean edgesCross(float e0x0, float e0y0, float e0x1, float e0y1, float e1x0, float e1y0, float e1x1, float e1y1) {
        float ax = e0x1 - e0x0;
        float ay = e0y1 - e0y0;
        float bx = e1x1 - e1x0;
        float by = e1y1 - e1y0;
        float cx = e1x0 - e0x0;
        float cy = e1y0 - e0y0;
        float dx = e1x1 - e0x0;
        float dy = e1y1 - e0y0;
        float ex = e0x0 - e1x0;
        float ey = e0y0 - e1y0;
        float fx = e0x1 - e1x0;
        float fy = e0y1 - e1y0;
        if ((ax * cy - ay * cx) * (ax * dy - ay * dx) >= 0.0f) {
            return false;
        }
        return !((bx * ey - by * ex) * (bx * fy - by * fx) >= 0.0f);
    }
}

