/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.Pair;

public class KNN {
    private int nrNeighbors = 5;

    public KNN(int nrNeighbors) {
        this.nrNeighbors = nrNeighbors;
    }

    public Pair[][] execute(Matrix matrix, Dissimilarity diss) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.execute(dmat);
    }

    public Pair[][] execute(DistanceMatrix dmat) throws IOException {
        int j;
        int i;
        long start = System.currentTimeMillis();
        Pair[][] neighbors = null;
        if (this.nrNeighbors > dmat.getElementCount() - 1) {
            throw new IOException("Number of neighbors bigger than the number of elements minus one (an element is not computed as a neighbor of itself)!");
        }
        neighbors = new Pair[dmat.getElementCount()][];
        for (i = 0; i < neighbors.length; ++i) {
            neighbors[i] = new Pair[this.nrNeighbors];
            for (j = 0; j < neighbors[i].length; ++j) {
                neighbors[i][j] = new Pair(-1, Float.MAX_VALUE);
            }
        }
        for (i = 0; i < dmat.getElementCount(); ++i) {
            block3: for (j = 0; j < dmat.getElementCount(); ++j) {
                float dist;
                if (i == j || !((dist = dmat.getDistance(i, j)) < neighbors[i][neighbors[i].length - 1].value)) continue;
                for (int k = 0; k < neighbors[i].length; ++k) {
                    if (!(neighbors[i][k].value > dist)) continue;
                    for (int n = neighbors[i].length - 1; n > k; --n) {
                        neighbors[i][n].index = neighbors[i][n - 1].index;
                        neighbors[i][n].value = neighbors[i][n - 1].value;
                    }
                    neighbors[i][k].index = j;
                    neighbors[i][k].value = dist;
                    continue block3;
                }
            }
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "KNN time: " + (float)(finish - start) / 1000.0f + "s");
        return neighbors;
    }
}

