/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.ArrayList;
import visualizer.graph.Vertex;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.Pair;
import visualizer.util.Prim;

public class MSTEdges {
    private ArrayList<Vertex> vertex;
    private ArrayList<String> names;

    public MSTEdges(ArrayList<Vertex> vertex, ArrayList<String> names) {
        this.vertex = vertex;
        this.names = names;
    }

    public Pair[][] execute(Matrix matrix, Dissimilarity diss) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.execute(dmat);
    }

    public Pair[][] execute(DistanceMatrix dmat) {
        Prim prim = new Prim(dmat);
        ArrayList<Prim.Edge> edges = prim.prim();
        this.validate(edges);
        ArrayList neigh_aux = new ArrayList();
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            neigh_aux.add(new ArrayList());
        }
        for (Prim.Edge e : edges) {
            ((ArrayList)neigh_aux.get(e.node1)).add(new Pair(e.node2, e.len));
        }
        Pair[][] neighborhood = new Pair[dmat.getElementCount()][];
        for (int i = 0; i < neigh_aux.size(); ++i) {
            neighborhood[i] = new Pair[((ArrayList)neigh_aux.get(i)).size()];
            for (int j = 0; j < ((ArrayList)neigh_aux.get(i)).size(); ++j) {
                neighborhood[i][j] = (Pair)((ArrayList)neigh_aux.get(i)).get(j);
            }
        }
        return neighborhood;
    }

    private void validate(ArrayList<Prim.Edge> edges) {
        int[] indexes = new int[this.names.size()];
        int i = 0;
        while (i < this.vertex.size()) {
            int index = this.names.indexOf(this.vertex.get(i).getUrl());
            indexes[index] = i++;
        }
        for (Prim.Edge e : edges) {
            e.node1 = indexes[e.node1];
            e.node2 = indexes[e.node2];
        }
    }
}

