/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import visualizer.corpus.Corpus;
import visualizer.corpus.CorpusFactory;
import visualizer.graph.Graph;
import visualizer.graph.ImageCollection;
import visualizer.graph.Vertex;
import visualizer.util.SystemPropertiesManager;
import visualizer.util.filefilter.PExFileFilter;
import visualizer.util.filefilter.ZIPFilter;

public class OpenDialog {
    private static String _filename;
    private static JFileChooser dialog;

    public static int showOpenDialog(PExFileFilter filter, Component parent) {
        if (dialog == null) {
            dialog = new JFileChooser();
        }
        _filename = null;
        dialog.resetChoosableFileFilters();
        dialog.setAcceptAllFileFilterUsed(false);
        if (filter != null) {
            dialog.setFileFilter(filter);
        }
        dialog.setMultiSelectionEnabled(false);
        dialog.setDialogTitle("Open file");
        dialog.setSelectedFile(new File(""));
        SystemPropertiesManager m = SystemPropertiesManager.getInstance();
        dialog.setCurrentDirectory(new File(m.getProperty(filter.getProperty())));
        int result = dialog.showOpenDialog(parent);
        if (result == 0) {
            _filename = dialog.getSelectedFile().getAbsolutePath();
            m.setProperty(filter.getProperty(), dialog.getSelectedFile().getParent());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean forceCheck(Graph graph, Component parent) {
        if (dialog == null) {
            dialog = new JFileChooser();
        }
        _filename = null;
        String Filename = new String();
        String Extension = ".txt";
        Vector FileUrls = new Vector();
        int count = 0;
        int valid = 0;
        if (graph != null) {
            dialog.resetChoosableFileFilters();
            dialog.setAcceptAllFileFilterUsed(false);
            dialog.setFileFilter(new ZIPFilter());
            dialog.setMultiSelectionEnabled(false);
            dialog.setSelectedFile(new File(""));
            dialog.setDialogTitle("Force open file");
            SystemPropertiesManager m = SystemPropertiesManager.getInstance();
            dialog.setCurrentDirectory(new File(m.getProperty("ZIP.DIR")));
            int result = dialog.showOpenDialog(parent);
            if (result == 0) {
                String message;
                int answer;
                ImageCollection ic;
                Corpus corpus;
                String fileName = dialog.getSelectedFile().getAbsolutePath();
                m.setProperty("ZIP.DIR", dialog.getSelectedFile().getParent());
                if (fileName != null) {
                    ZipFile zip = null;
                    try {
                        Vector<String> filenames_aux = new Vector<String>();
                        zip = new ZipFile(fileName);
                        Enumeration<? extends ZipEntry> entries = zip.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry2;
                            ZipEntry entry = entries.nextElement();
                            if (entry.isDirectory() || (entry2 = zip.getEntry(entry.getName())) == null) continue;
                            filenames_aux.add(entry2.getName().trim());
                        }
                        ArrayList<Integer> index_aux = new ArrayList<Integer>();
                        for (int i = 0; i < filenames_aux.size(); ++i) {
                            index_aux.add(i);
                        }
                        int[] index = new int[filenames_aux.size()];
                        int i = 0;
                        for (int j = 0; j < index.length; ++j) {
                            int ind = (int)Math.pow(2.0, i);
                            if (ind >= index_aux.size()) {
                                ind = 0;
                            }
                            index[j] = (Integer)index_aux.get(ind);
                            index_aux.remove(ind);
                            ++i;
                        }
                        for (i = 0; i < filenames_aux.size(); ++i) {
                            FileUrls.add(filenames_aux.elementAt(index[i]));
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                if (((String)FileUrls.elementAt(0)).endsWith(".txt")) {
                    corpus = CorpusFactory.getInstance(fileName, graph.getProjectionData());
                    Extension = ".txt";
                    for (Vertex v : graph.getVertex()) {
                        Filename = v.getUrl();
                        if (Filename.lastIndexOf(46) != -1) {
                            Filename = Filename.substring(0, v.getUrl().lastIndexOf(46));
                        }
                        if (corpus.getIds().contains(Filename + Extension)) {
                            ++count;
                        }
                        if (!v.isValid()) continue;
                        ++valid;
                    }
                } else if (((String)FileUrls.elementAt(0)).endsWith(".jpg")) {
                    ic = new ImageCollection(fileName);
                    Extension = ".jpg";
                    for (Vertex v : graph.getVertex()) {
                        Filename = v.getUrl().trim();
                        if (Filename.lastIndexOf(46) != -1) {
                            Filename = Filename.substring(0, v.getUrl().lastIndexOf(46));
                        }
                        if (ic.getImageUrls().contains(Filename + Extension)) {
                            ++count;
                        }
                        if (!v.isValid()) continue;
                        ++valid;
                    }
                }
                if (count != valid && (answer = JOptionPane.showOptionDialog(dialog, message = "Only " + count + " corresponding files were found in the corpus!\n" + "The projection has " + valid + " files. Would like to proceed?", "Openning Warning", 0, 2, null, null, null)) == 1) {
                    return false;
                }
                for (Vertex v : graph.getVertex()) {
                    if (!v.isValid()) continue;
                    Filename = v.getUrl();
                    if (Filename.lastIndexOf(46) != -1) {
                        Filename = Filename.substring(0, v.getUrl().lastIndexOf(46));
                    }
                    v.setUrl(Filename + Extension);
                }
                if (((String)FileUrls.elementAt(0)).endsWith(".jpg")) {
                    ic = new ImageCollection(fileName);
                    graph.setImageCollection(ic);
                } else if (((String)FileUrls.elementAt(0)).endsWith(".txt")) {
                    corpus = CorpusFactory.getInstance(fileName, graph.getProjectionData());
                    graph.setCorpus(corpus);
                    graph.getProjectionData().setSourceFile(fileName);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean checkCorpus(Graph graph, Component parent) {
        if (dialog == null) {
            dialog = new JFileChooser();
        }
        _filename = null;
        if (graph != null && graph.getCorpus() == null) {
            dialog.resetChoosableFileFilters();
            dialog.setAcceptAllFileFilterUsed(false);
            dialog.setFileFilter(new ZIPFilter());
            dialog.setMultiSelectionEnabled(false);
            dialog.setSelectedFile(new File(""));
            dialog.setDialogTitle("Open CORPUS file");
            SystemPropertiesManager m = SystemPropertiesManager.getInstance();
            dialog.setCurrentDirectory(new File(m.getProperty("ZIP.DIR")));
            int result = dialog.showOpenDialog(parent);
            if (result == 0) {
                String message;
                int answer;
                String fileName = dialog.getSelectedFile().getAbsolutePath();
                m.setProperty("ZIP.DIR", dialog.getSelectedFile().getParent());
                Corpus corpus = CorpusFactory.getInstance(fileName, graph.getProjectionData());
                int count = 0;
                int valid = 0;
                for (Vertex v : graph.getVertex()) {
                    String filename = v.getUrl();
                    if (corpus.getIds().contains(filename)) {
                        ++count;
                    }
                    if (!v.isValid()) continue;
                    ++valid;
                }
                if (count != valid && (answer = JOptionPane.showOptionDialog(dialog, message = "Only " + count + " corresponding files were found in the corpus!\n" + "The projection has " + valid + " files. Would like to proceed?", "Openning Warning", 0, 2, null, null, null)) == 1) {
                    return false;
                }
                graph.setCorpus(corpus);
                graph.getProjectionData().setSourceFile(fileName);
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean checkImages(Graph graph, Component parent) {
        if (dialog == null) {
            dialog = new JFileChooser();
        }
        _filename = null;
        if (graph != null && graph.getImageCollection() == null) {
            dialog.resetChoosableFileFilters();
            dialog.setAcceptAllFileFilterUsed(false);
            dialog.setFileFilter(new ZIPFilter());
            dialog.setMultiSelectionEnabled(false);
            dialog.setSelectedFile(new File(""));
            dialog.setDialogTitle("Open IMAGES file");
            SystemPropertiesManager m = SystemPropertiesManager.getInstance();
            dialog.setCurrentDirectory(new File(m.getProperty("ZIP.DIR")));
            int result = dialog.showOpenDialog(parent);
            if (result == 0) {
                String message;
                int answer;
                String fileName = dialog.getSelectedFile().getAbsolutePath();
                m.setProperty("ZIP.DIR", dialog.getSelectedFile().getParent());
                ImageCollection ic = new ImageCollection(fileName);
                int count = 0;
                int valid = 0;
                for (Vertex v : graph.getVertex()) {
                    String filename = v.getUrl().trim();
                    if (ic.getImageUrls().contains(filename)) {
                        ++count;
                    }
                    if (!v.isValid()) continue;
                    ++valid;
                }
                if (count != valid && (answer = JOptionPane.showOptionDialog(dialog, message = "Only " + count + " corresponding files were found in the images file!\n" + "The projection has " + valid + " files. Would like to proceed?", "Openning Warning", 0, 2, null, null, null)) == 1) {
                    return false;
                }
                graph.setImageCollection(ic);
                return true;
            }
            return false;
        }
        return true;
    }

    public static String getFilename() {
        return _filename;
    }

    public static JFileChooser getJFileChooser() {
        if (dialog == null) {
            dialog = new JFileChooser();
        }
        return dialog;
    }
}

