/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemPropertiesManager {
    private String filename = "config/system.properties";
    private Properties properties = null;
    private static SystemPropertiesManager _instance = null;

    private SystemPropertiesManager() {
        try {
            File f = new File(this.filename);
            if (f.exists()) {
                this.properties = new Properties();
                FileInputStream in = new FileInputStream(this.filename);
                this.properties.load(in);
                in.close();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SystemPropertiesManager getInstance() {
        if (_instance == null) {
            _instance = new SystemPropertiesManager();
        }
        return _instance;
    }

    public String getProperty(String id) {
        if (this.properties == null) {
            return "";
        }
        if (this.properties.containsKey(id)) {
            return this.properties.getProperty(id);
        }
        return "";
    }

    public void setProperty(String id, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(id, value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.properties.store(out, "Recording the system's properties");
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }
}

