/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JTextArea;
import javax.swing.Timer;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class TextFromPDF {
    public void extract(JTextArea status, String directory, String corpora) throws IOException {
        ProcessAll process = new ProcessAll(status, directory, corpora);
        if (process.getPdfFiles(directory).size() <= 0) {
            throw new IOException("The directory does not contain PDF files!");
        }
        process.start();
    }

    class PDFProcessor
    extends Thread
    implements ActionListener {
        public static final int time = 15000;
        private String pdfFile;
        private Timer timer;
        private ZipOutputStream zout;
        private JTextArea status;

        public PDFProcessor(JTextArea status, String pdfFile, ZipOutputStream zout) {
            this.pdfFile = pdfFile;
            this.zout = zout;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PDDocument doc = null;
            try {
                String textFile = this.pdfFile.substring(this.pdfFile.lastIndexOf(System.getProperty("file.separator")) + 1, this.pdfFile.lastIndexOf(".")) + ".txt";
                ZipEntry entry = new ZipEntry(textFile);
                this.zout.putNextEntry(entry);
                doc = PDDocument.load((String)this.pdfFile);
                String txt = this.extract(doc, 1, doc.getNumberOfPages());
                this.zout.write(txt.getBytes(), 0, txt.length());
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (this.timer != null) {
                    this.timer.stop();
                }
                try {
                    if (doc != null) {
                        doc.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        public void start() {
            this.timer = new Timer(15000, this);
            this.timer.start();
            super.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.status.append("Time exceeded: " + this.pdfFile + "\n");
            if (this.timer != null) {
                this.timer.stop();
            }
            this.interrupt();
        }

        private String extract(PDDocument doc, int startPage, int endPage) throws IOException {
            PDFTextStripper stripper = new PDFTextStripper();
            if (startPage != 0 && endPage != 0) {
                stripper.setStartPage(startPage);
                stripper.setEndPage(endPage);
            }
            return stripper.getText(doc);
        }
    }

    class ProcessAll
    extends Thread {
        private JTextArea status;
        private String directory;
        private String corpora;

        public ProcessAll(JTextArea status, String directory, String corpora) {
            this.status = status;
            this.directory = directory;
            this.corpora = corpora;
        }

        public ArrayList<File> getPdfFiles(String directory) {
            File[] files;
            ArrayList<File> pdfFiles = new ArrayList<File>();
            File f = new File(directory);
            for (File file : files = f.listFiles()) {
                if (!file.getAbsolutePath().toLowerCase().endsWith(".pdf")) continue;
                pdfFiles.add(file);
            }
            return pdfFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File f = new File(this.directory);
            Thread proc = null;
            DeflaterOutputStream zout = null;
            try {
                FileOutputStream dest = new FileOutputStream(this.corpora);
                zout = new ZipOutputStream(new BufferedOutputStream(dest));
                ((ZipOutputStream)zout).setMethod(8);
                ArrayList<File> pdfFiles = this.getPdfFiles(this.directory);
                for (File pdf : pdfFiles) {
                    while (proc != null && proc.isAlive()) {
                    }
                    this.status.append("Converting: " + pdf.getName() + "\n");
                    proc = new PDFProcessor(this.status, pdf.getAbsolutePath(), (ZipOutputStream)zout);
                    ((PDFProcessor)proc).start();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (zout != null) {
                    try {
                        while (proc != null && proc.isAlive()) {
                        }
                        zout.flush();
                        ((ZipOutputStream)zout).finish();
                        ((ZipOutputStream)zout).close();
                        this.status.append("FINISHED...");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

