/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import visualizer.graph.Connectivity;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.matrix.Vector;
import visualizer.projection.SourceType;
import visualizer.util.Pair;
import visualizer.util.SystemPropertiesManager;
import visualizer.view.color.ColorTable;
import visualizer.view.legend.Legend;

public class Util {
    public static Connectivity importConnectivity(ArrayList<Vertex> vertex, String filename) throws IOException {
        Connectivity con = null;
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        for (Vertex v : vertex) {
            index.put(v.getUrl(), (int)v.getId());
        }
        ArrayList neigh_aux = new ArrayList();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null && (line.trim().length() <= 0 || line.lastIndexOf(35) != -1)) {
            }
            con = new Connectivity(line.trim());
            for (int i = 0; i < index.size(); ++i) {
                neigh_aux.add(new ArrayList());
            }
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, ";");
                Integer from = (Integer)index.get(t.nextToken());
                Integer to = (Integer)index.get(t.nextToken());
                float len = Float.parseFloat(t.nextToken());
                if (from == null || to == null) continue;
                ((ArrayList)neigh_aux.get(from)).add(new Pair(to, len));
                ((ArrayList)neigh_aux.get(to)).add(new Pair(from, len));
            }
            Pair[][] neighborhood = new Pair[index.size()][];
            for (int i = 0; i < neigh_aux.size(); ++i) {
                neighborhood[i] = new Pair[((ArrayList)neigh_aux.get(i)).size()];
                for (int j = 0; j < ((ArrayList)neigh_aux.get(i)).size(); ++j) {
                    neighborhood[i][j] = (Pair)((ArrayList)neigh_aux.get(i)).get(j);
                }
            }
            con.create(vertex, neighborhood);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return con;
    }

    public static void exportConnectivity(Connectivity connectivity, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write(connectivity.getName());
            out.write("\r\n");
            for (Edge e : connectivity.getEdges()) {
                out.write(e.getSource().getUrl());
                out.write(";");
                out.write(e.getTarget().getUrl());
                out.write(";");
                out.write(Float.toString(e.getLength()));
                out.write("\r\n");
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void importScalars(Graph graph, String filename) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            ArrayList<String> scalars = new ArrayList<String>();
            int linenumber = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                ++linenumber;
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, ";");
                while (t.hasMoreTokens()) {
                    scalars.add(t.nextToken().trim());
                }
                break block9;
            }
            HashMap<String, Vertex> index = new HashMap<String, Vertex>();
            for (Vertex v : graph.getVertex()) {
                index.put(v.getUrl().trim(), v);
            }
            while ((line = in.readLine()) != null) {
                ++linenumber;
                ArrayList<Float> values = new ArrayList<Float>();
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, ";", false);
                String fname = t.nextToken().trim();
                while (t.hasMoreTokens()) {
                    float value = Float.parseFloat(t.nextToken().trim());
                    values.add(Float.valueOf(value));
                }
                if (scalars.size() != values.size()) {
                    throw new IOException("The number of values for one scalar does not match with the number of declared scalars.\r\nCheck line " + linenumber + " of the file.");
                }
                Vertex v = (Vertex)index.get(fname);
                if (v == null) continue;
                for (int i = 0; i < scalars.size(); ++i) {
                    Scalar s = graph.addScalar((String)scalars.get(i));
                    v.setScalar(s, ((Float)values.get(i)).floatValue());
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void exportScalars(Graph graph, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < graph.getScalars().size(); ++i) {
                if (graph.getScalars().get(i).getName().equals("...")) continue;
                out.write(graph.getScalars().get(i).getName().replaceAll(";", "_"));
                if (i >= graph.getScalars().size() - 1) continue;
                out.write(";");
            }
            out.write("\r\n");
            for (Vertex v : graph.getVertex()) {
                if (!v.isValid()) continue;
                out.write(v.getUrl() + ";");
                for (int i = 0; i < graph.getScalars().size(); ++i) {
                    if (graph.getScalars().get(i).getName().equals("...")) continue;
                    float scalar = v.getScalar(graph.getScalars().get(i));
                    out.write(Float.toString(scalar).replaceAll(";", "_"));
                    if (i >= graph.getScalars().size() - 1) continue;
                    out.write(";");
                }
                out.write("\r\n");
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static Graph importProjection(String filename) throws IOException {
        Graph graph = new Graph();
        Matrix matrix = MatrixFactory.getInstance(filename);
        Scalar sdots = graph.addScalar("...");
        Scalar scdata = graph.addScalar("cdata");
        int index = graph.addTitle("file name");
        ArrayList<Vertex> vertex = graph.getVertex();
        for (int id = 0; id < matrix.getRowCount(); ++id) {
            Vector vec = matrix.getRow(id);
            Vertex v = new Vertex(id, vec.getValue(0), vec.getValue(1));
            v.setScalar(sdots, 0.0f);
            v.setScalar(scdata, vec.getKlass());
            v.setUrl(vec.getId());
            v.setTitle(index, vec.getId());
            vertex.add(v);
        }
        graph.setVertex(vertex);
        Connectivity dotsCon = new Connectivity("...");
        graph.addConnectivity(dotsCon);
        graph.getProjectionData().setSourceFile(filename);
        graph.getProjectionData().setNumberObjects(vertex.size());
        graph.getProjectionData().setSourceType(SourceType.POINTS);
        return graph;
    }

    public static Matrix exportProjection(Graph graph, Scalar scalar) throws IOException {
        DenseMatrix matrix = new DenseMatrix();
        if (scalar == null) {
            scalar = graph.getScalarByName("...");
        }
        for (int i = 0; i < graph.getVertex().size(); ++i) {
            float[] point = new float[]{graph.getVertex().get(i).getX(), graph.getVertex().get(i).getY()};
            float cdata = graph.getVertex().get(i).getScalar(scalar);
            String id = graph.getVertex().get(i).getUrl();
            ((Matrix)matrix).addRow(new DenseVector(point, id, cdata));
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("x");
        attributes.add("y");
        matrix.setAttributes(attributes);
        return matrix;
    }

    public static void exportVTKFile(Graph graph, String filename, Connectivity connectivity) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write("# vtk DataFile Version 2.0\r\n");
            out.write("output\r\n");
            out.write("ASCII\r\n");
            out.write("DATASET POLYDATA\r\n");
            out.write("POINTS ");
            out.write(Integer.toString(graph.getVertex().size()));
            out.write(" float\r\n");
            for (Vertex v : graph.getVertex()) {
                Scalar s = graph.getScalarByName("cdata");
                out.write(Float.toString(v.getX()));
                out.write(" ");
                out.write(Float.toString(v.getY()));
                out.write(" ");
                out.write(Float.toString(v.getScalar(s)));
                out.write("\r\n");
            }
            ArrayList<Edge> edges = connectivity.getEdges();
            int numberEdges = edges.size();
            out.write("\r\nLINES ");
            out.write(Integer.toString(numberEdges));
            out.write(" ");
            out.write(Integer.toString(numberEdges * 3));
            out.write("\r\n");
            for (Edge e : edges) {
                out.write("2 ");
                out.write(Long.toString(e.getSource().getId()));
                out.write(" ");
                out.write(Long.toString(e.getTarget().getId()));
                out.write("\r\n");
            }
            out.write("\r\nPOINT_DATA ");
            out.write(Integer.toString(graph.getVertex().size()));
            out.write("\r\n");
            for (Scalar s : graph.getScalars()) {
                out.write("SCALARS ");
                out.write(s.getName().replace("'", " ").trim().replace(" ", "+"));
                out.write(" float\r\n");
                out.write("LOOKUP_TABLE default\r\n");
                for (Vertex v : graph.getVertex()) {
                    out.write(Float.toString(v.getScalar(s)));
                    out.write("\r\n");
                }
                out.write("\r\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        try {
            out = new BufferedWriter(new FileWriter(filename + ".names"));
            for (Vertex v : graph.getVertex()) {
                String title = v.toString();
                if (title.length() > 125) {
                    title = title.substring(0, 124);
                }
                out.write(title);
                out.write("\r\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + ".names" + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + ".names" + "\"");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void exportTitles(Graph graph, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < graph.getTitles().size() - 1; ++i) {
                out.write(graph.getTitles().get(i).replaceAll(";", "_"));
                out.write(";");
            }
            out.write(graph.getTitles().get(graph.getTitles().size() - 1));
            out.write("\r\n");
            int[] titleIndex = new int[graph.getTitles().size()];
            for (int i = 0; i < titleIndex.length; ++i) {
                titleIndex[i] = graph.getTitleIndex(graph.getTitles().get(i));
            }
            for (Vertex v : graph.getVertex()) {
                if (!v.isValid()) continue;
                out.write(v.getUrl());
                out.write(";");
                for (int i = 0; i < titleIndex.length - 1; ++i) {
                    v.changeTitle(titleIndex[i]);
                    out.write(v.toString().replaceAll(";", "_"));
                    out.write(";");
                }
                v.changeTitle(titleIndex[titleIndex.length - 1]);
                out.write(v.toString().replaceAll(";", "_"));
                out.write("\r\n");
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException ex) {
            throw new IOException("Problems writing the file \"" + filename + "\"");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void importTitles(Graph graph, String filename) throws IOException {
        BufferedReader in = null;
        try {
            StringTokenizer t;
            in = new BufferedReader(new FileReader(filename));
            ArrayList<String> titles = new ArrayList<String>();
            int linenumber = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                ++linenumber;
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                t = new StringTokenizer(line, ";");
                while (t.hasMoreTokens()) {
                    String title = t.nextToken().trim();
                    titles.add(title);
                }
                break block9;
            }
            while ((line = in.readLine()) != null) {
                ++linenumber;
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                t = new StringTokenizer(line, ";");
                ArrayList<String> values = new ArrayList<String>();
                String fname = t.nextToken().trim();
                while (t.hasMoreTokens()) {
                    String title = t.nextToken().trim();
                    values.add(title);
                }
                if (titles.size() != values.size()) {
                    throw new IOException("The number of values for one scalar does not match with the number of declared scalars.\r\nCheck line " + linenumber + " of the file.");
                }
                for (Vertex v : graph.getVertex()) {
                    if (!fname.equals(v.getUrl())) continue;
                    for (int i = 0; i < titles.size(); ++i) {
                        int index = graph.addTitle((String)titles.get(i));
                        v.setTitle(index, (String)values.get(i));
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void normalize(float[][] result) {
        int lvfield;
        int lvins;
        int lvdimensions = result[0].length;
        int lvinstances = result.length;
        float[] lvlowrange = new float[lvdimensions];
        float[] lvhighrange = new float[lvdimensions];
        for (lvins = 0; lvins < lvinstances; ++lvins) {
            for (lvfield = 0; lvfield < lvdimensions; ++lvfield) {
                if (lvins == 0) {
                    lvlowrange[lvfield] = result[lvins][lvfield];
                    lvhighrange[lvfield] = result[lvins][lvfield];
                    continue;
                }
                lvlowrange[lvfield] = lvlowrange[lvfield] > result[lvins][lvfield] ? result[lvins][lvfield] : lvlowrange[lvfield];
                lvhighrange[lvfield] = lvhighrange[lvfield] < result[lvins][lvfield] ? result[lvins][lvfield] : lvhighrange[lvfield];
            }
        }
        for (lvins = 0; lvins < lvinstances; ++lvins) {
            for (lvfield = 0; lvfield < lvdimensions; ++lvfield) {
                result[lvins][lvfield] = (double)(lvhighrange[lvfield] - lvlowrange[lvfield]) > 0.0 ? (result[lvins][lvfield] - lvlowrange[lvfield]) / (lvhighrange[lvfield] - lvlowrange[lvfield]) : 0.0f;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countFiles(String corpora) {
        int numberFiles = 0;
        ZipFile zip = null;
        try {
            zip = new ZipFile(corpora);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                ++numberFiles;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return numberFiles;
    }

    public static float[][] transpose(float[][] matrix) {
        float[][] transpMatrix = new float[matrix[0].length][];
        for (int i = 0; i < matrix[0].length; ++i) {
            transpMatrix[i] = new float[matrix.length];
            for (int j = 0; j < matrix.length; ++j) {
                transpMatrix[i][j] = matrix[j][i];
            }
        }
        return transpMatrix;
    }

    public static int countObjectsDistanceFile(String filename) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            int n = Integer.parseInt(in.readLine());
            return n;
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static int countObjectsPointsFile(String filename) throws IOException {
        BufferedReader in = null;
        try {
            int nrobjs;
            in = new BufferedReader(new FileReader(filename));
            char[] header = in.readLine().trim().toCharArray();
            if (header.length != 2) {
                throw new IOException("Wrong format of header information.");
            }
            int n = nrobjs = Integer.parseInt(in.readLine());
            return n;
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePrefuseGraph(Graph graph, String filename, Connectivity connectivity) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write("<!--  An excerpt of an egocentric social network  -->\n");
            out.write("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\">\n");
            out.write("<graph edgedefault=\"undirected\">");
            out.write("<!-- data schema -->\n");
            out.write("<key id=\"label\" for=\"node\" attr.name=\"label\" attr.type=\"string\"/>\n");
            out.write("<key id=\"cdata\" for=\"node\" attr.name=\"cdata\" attr.type=\"float\"/>\n");
            out.write("<!-- nodes -->\n");
            for (int i = 0; i < graph.getVertex().size(); ++i) {
                Vertex v = graph.getVertex().get(i);
                out.write("<node id=\"");
                out.write(Integer.toString(i));
                out.write("\">\n");
                out.write("<data key=\"label\">");
                if (v.isValid()) {
                    if (v.toString().length() <= 5) {
                        out.write(v.toString());
                    } else {
                        out.write(v.toString().substring(0, 5));
                    }
                } else {
                    out.write("_");
                }
                out.write("</data>\n");
                out.write("<data key=\"cdata\">");
                if (v.isValid()) {
                    Scalar s = graph.getScalarByName("cdata");
                    out.write(Float.toString(v.getScalar(s)));
                } else {
                    out.write("-1.0");
                }
                out.write("</data>\n");
                out.write("</node>\n");
            }
            if (connectivity != null) {
                for (Edge e : connectivity.getEdges()) {
                    out.write("<edge source=\"" + Long.toString(e.getSource().getId()) + "\" target=\"" + Long.toString(e.getTarget().getId()) + "\"></edge>\n");
                }
            }
            out.write("</graph>\n");
            out.write("</graphml>\n");
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void log(boolean console, boolean file) throws IOException {
        int i;
        Handler[] handlers;
        Logger rootLogger;
        String filename = "log%g.txt";
        int limit = 10000000;
        int numLogFiles = 5;
        if (file) {
            FileHandler handler = new FileHandler(filename, limit, numLogFiles, true);
            handler.setFormatter(new SimpleFormatter());
            handler.setLevel(Level.ALL);
            Logger.getLogger("").addHandler(handler);
            Logger.getLogger("Util").log(Level.INFO, "Adding the file logging.");
        } else {
            Logger.getLogger("Util").log(Level.INFO, "Removing the file logging.");
            rootLogger = Logger.getLogger("");
            handlers = rootLogger.getHandlers();
            for (i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof FileHandler)) continue;
                rootLogger.removeHandler(handlers[i]);
            }
        }
        if (console) {
            rootLogger = Logger.getLogger("");
            handlers = rootLogger.getHandlers();
            for (i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof ConsoleHandler)) continue;
                rootLogger.removeHandler(handlers[i]);
            }
            rootLogger.addHandler(new ConsoleHandler());
            Logger.getLogger("Util").log(Level.INFO, "Adding console logging.");
        } else {
            Logger.getLogger("Util").log(Level.INFO, "Removing console logging.");
            rootLogger = Logger.getLogger("");
            handlers = rootLogger.getHandlers();
            for (i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof ConsoleHandler)) continue;
                rootLogger.removeHandler(handlers[i]);
            }
        }
    }

    public static Legend readLegend(ColorTable table, String filename) throws IOException {
        BufferedReader in = null;
        Legend legend = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            String title = in.readLine();
            legend = new Legend(table, title);
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, ";");
                String name = t.nextToken();
                float value = Float.parseFloat(t.nextToken());
                legend.addItem(name, value);
            }
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return legend;
    }

    public static void unzipImages(String filename) {
        try {
            String unzipDir = SystemPropertiesManager.getInstance().getProperty("UNZIP.DIR");
            ZipFile zf = new ZipFile(filename);
            Enumeration<? extends ZipEntry> zipEnum = zf.entries();
            while (zipEnum.hasMoreElements()) {
                int ch;
                ZipEntry item = zipEnum.nextElement();
                String newfile = item.getName();
                InputStream is = zf.getInputStream(item);
                FileOutputStream fos = new FileOutputStream(unzipDir + "\\" + newfile);
                while ((ch = is.read()) != -1) {
                    fos.write(ch);
                }
                is.close();
                fos.close();
            }
            zf.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void deleteFiles(String directory) {
        File dir = new File(directory);
        String[] files = dir.list();
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File f = new File(directory + "\\" + files[i]);
                f.delete();
            }
        }
    }

    public static java.util.Vector<String> readOldNamesFile(String filename) throws IOException {
        java.util.Vector<String> elements = new java.util.Vector<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                elements.add(line.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (elements.size() > 0) {
            return elements;
        }
        return null;
    }

    public static ArrayList<String> read(String filename) throws IOException {
        ArrayList<String> elements = new ArrayList<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                elements.add(line.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (elements.size() > 0) {
            return elements;
        }
        return null;
    }
}

