/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DescriptionView
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static DescriptionView instance;
    private JPanel buttonPanel;
    private JPanel dataPanel;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private JButton okButton;

    private DescriptionView(JFrame parent) {
        super(parent);
        this.initComponents();
        this.setModal(true);
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Description");
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Map Description"));
        this.descriptionTextArea.setColumns(35);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(10);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.dataPanel.add((Component)this.descriptionScrollPane, "Center");
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DescriptionView.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static DescriptionView getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new DescriptionView(parent);
        }
        return instance;
    }

    public void display(String msg) {
        this.pack();
        this.descriptionTextArea.setText(msg);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DescriptionView(null).setVisible(true);
            }
        });
    }
}

