/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FileViewer
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static FileViewer instance;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JTextField filelabelField;
    private JPanel filelabelPanel;
    private JTextArea textArea;
    private JScrollPane textAreaScrollPane;

    private FileViewer(JFrame parent) {
        super(parent);
        this.initComponents();
        this.setModal(true);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.textAreaScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.filelabelPanel = new JPanel();
        this.filelabelField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("File Viewer");
        this.closeButton.setText("Close");
        this.closeButton.setAutoscrolls(true);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileViewer.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.textAreaScrollPane.setBorder(BorderFactory.createTitledBorder("File Content"));
        this.textAreaScrollPane.setAutoscrolls(true);
        this.textArea.setColumns(70);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(20);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setAutoscrolls(false);
        this.textAreaScrollPane.setViewportView(this.textArea);
        this.getContentPane().add((Component)this.textAreaScrollPane, "Center");
        this.filelabelPanel.setLayout(new BorderLayout());
        this.filelabelPanel.setBorder(BorderFactory.createTitledBorder("File Label"));
        this.filelabelField.setEditable(false);
        this.filelabelPanel.add((Component)this.filelabelField, "Center");
        this.getContentPane().add((Component)this.filelabelPanel, "North");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static FileViewer getInstance(JFrame parent) {
        if (instance == null) {
            instance = new FileViewer(parent);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(String label, String corporaFilename, String filename) {
        this.textArea.setText("");
        this.filelabelField.setText(label);
        this.filelabelField.setCaretPosition(0);
        ZipFile zip = null;
        try {
            zip = new ZipFile(corporaFilename);
            ZipEntry entry = zip.getEntry(filename);
            if (entry != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                while ((line = in.readLine()) != null) {
                    this.textArea.append(line + "\n");
                }
                this.textArea.setCaretPosition(0);
                this.pack();
                this.setLocationRelativeTo(this.getParent());
                this.setVisible(true);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FileViewer(null).setVisible(true);
            }
        });
    }
}

