/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.view.Viewer;

public class MultipleImage
extends JDialog {
    private static final long serialVersionUID = 1L;
    private FilePane showedFilePane = null;
    private final int numberCharsAtTabTitle = 20;
    private static MultipleImage instance;
    private ArrayList<Vertex> vertex;
    private Graph graph;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel dataPanel;
    private JTabbedPane fileviewTabbedPane;

    private MultipleImage(JFrame parent) {
        super(parent);
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.dataPanel = new JPanel();
        this.fileviewTabbedPane = new JTabbedPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("File Multiple View");
        this.setModal(true);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleImage.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.dataPanel.setLayout(new BorderLayout());
        this.fileviewTabbedPane.setMinimumSize(new Dimension(1000, 500));
        this.fileviewTabbedPane.setPreferredSize(new Dimension(800, 500));
        this.fileviewTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MultipleImage.this.fileviewTabbedPaneStateChanged(evt);
            }
        });
        this.dataPanel.add((Component)this.fileviewTabbedPane, "Center");
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.pack();
    }

    private void fileviewTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.fileviewTabbedPane.getSelectedComponent() instanceof FilePane) {
            this.showedFilePane = (FilePane)this.fileviewTabbedPane.getSelectedComponent();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static MultipleImage getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new MultipleImage(parent);
        }
        return instance;
    }

    public void display(Viewer gv, ArrayList<Vertex> vertex) {
        this.vertex = vertex;
        this.graph = gv.getGraph();
        this.fileviewTabbedPane.removeAll();
        if (vertex != null) {
            for (Vertex v : vertex) {
                if (!v.isValid()) continue;
                String label = v.toString();
                if (label.length() > this.numberCharsAtTabTitle) {
                    label = label.substring(0, this.numberCharsAtTabTitle - 3) + "...";
                }
                try {
                    Image im = this.graph.getImageCollection().getImage(v.getUrl());
                    this.fileviewTabbedPane.addTab(label, new FilePane(v.toString(), im, v.getUrl()));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void display(Viewer gv, Vertex vertex) {
        ArrayList<Vertex> neighbors = new ArrayList<Vertex>();
        gv.getGraph().getNeighbors(neighbors, null, gv.getCurrentConnectivity(), vertex, gv.getNeighborhoodDepth());
        if (neighbors.size() > 0) {
            neighbors.set(0, vertex);
        } else {
            neighbors.add(vertex);
        }
        this.display(gv, neighbors);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MultipleImage(null).setVisible(true);
            }
        });
    }

    class FilePane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel labelImage;
        private JTextField filelabelField;
        private JPanel filelabelPanel;
        private JEditorPane textArea;
        private JScrollPane textAreaScrollPane;
        private Highlighter.HighlightPainter myHighlightPainter = new MyHighlightPainter(Color.YELLOW);

        public FilePane(String label, Image img, String filename) {
            this.initComponents(label, img, filename);
        }

        private void initComponents(String label, Image img, String filename) {
            this.labelImage = new JLabel(new ImageIcon(img));
            this.filelabelPanel = new JPanel();
            this.filelabelField = new JTextField();
            this.setLayout(new BorderLayout());
            this.add((Component)this.labelImage, "Center");
            this.filelabelPanel.setLayout(new BorderLayout());
            this.filelabelPanel.setBorder(BorderFactory.createTitledBorder("File Label"));
            this.filelabelField.setEditable(false);
            this.filelabelPanel.add((Component)this.filelabelField, "Center");
            this.add((Component)this.filelabelPanel, "North");
            this.filelabelField.setText(label);
            this.filelabelField.setCaretPosition(0);
        }

        public void highlight(JTextComponent textComp, String pattern) {
            this.removeHighlights(textComp);
            try {
                Highlighter hilite = textComp.getHighlighter();
                Document doc = textComp.getDocument();
                String text = doc.getText(0, doc.getLength()).toLowerCase();
                int pos = 0;
                pos = text.indexOf(pattern.toLowerCase(), pos);
                if (pos >= 0) {
                    hilite.addHighlight(pos, pos + pattern.length(), this.myHighlightPainter);
                    this.textArea.setCaretPosition(pos);
                    pos += pattern.length();
                }
                while ((pos = text.indexOf(pattern.toLowerCase(), pos)) >= 0) {
                    hilite.addHighlight(pos, pos + pattern.length(), this.myHighlightPainter);
                    pos += pattern.length();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void removeHighlights(JTextComponent textComp) {
            Highlighter hilite = textComp.getHighlighter();
            Highlighter.Highlight[] hilites = hilite.getHighlights();
            for (int i = 0; i < hilites.length; ++i) {
                if (!(hilites[i].getPainter() instanceof MyHighlightPainter)) continue;
                hilite.removeHighlight(hilites[i]);
            }
        }

        class MyHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            public MyHighlightPainter(Color color) {
                super(color);
            }
        }
    }
}

