/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import visualizer.datamining.clustering.HierarchicalClusteringType;
import visualizer.graph.Connectivity;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.graph.coodination.Coordination;
import visualizer.graph.coodination.Mapping;
import visualizer.graph.listeners.VertexSelectionFactory;
import visualizer.topic.Topic;
import visualizer.view.ProjectionExplorerView;
import visualizer.view.color.ColorTable;

public abstract class Viewer
extends JInternalFrame {
    protected boolean graphChanged = false;
    protected static boolean movePoints = false;
    protected static VertexSelectionFactory.SelectionType type = VertexSelectionFactory.SelectionType.CREATE_TOPIC;
    protected boolean vertexLabelVisible = true;
    protected static boolean highlightTopic = false;
    protected boolean highQualityRender = true;
    protected ProjectionExplorerView pexview;
    protected int id;
    protected static int avaiableId = 1;
    protected Coordination coord;

    public Viewer(ProjectionExplorerView pexview) {
        this.pexview = pexview;
        this.id = avaiableId++;
    }

    public abstract void updateScalars(Scalar var1);

    public abstract void updateConnectivities(Connectivity var1);

    public abstract void updateCoordinations(Mapping var1);

    public abstract void updateTitles(String var1);

    public abstract Connectivity getCurrentConnectivity();

    public abstract Scalar getCurrentScalar();

    public abstract int getNeighborhoodDepth();

    public abstract void setNeighborhoodDepth(int var1);

    public abstract int saveOnClosing();

    public abstract void zoomIn();

    public abstract void zoomOut();

    public abstract boolean runForce();

    public abstract void cleanTopics();

    public abstract void addTopic(Topic var1);

    public abstract void cleanSelection(boolean var1);

    public abstract void selectVertices(ArrayList<Vertex> var1);

    public abstract ColorTable getColorTable();

    public abstract void updateImage();

    public abstract void colorAs(Scalar var1);

    public abstract Vertex getSelectedVertex();

    public abstract Font getViewerFont();

    public abstract void setViewerFont(Font var1);

    public abstract void setViewerBackground(Color var1);

    public abstract void deleteSelectedVertices();

    public abstract void saveToPngImageFile(String var1) throws IOException;

    public abstract void saveToEpsImageFile(String var1) throws IOException;

    public abstract ArrayList<Vertex> getSelectedVertex(Point var1, Point var2);

    public abstract Graph getGraph();

    public abstract String getCurrentTitle();

    public abstract void markNeighbors(Vertex var1);

    public static boolean isMovePoints() {
        return movePoints;
    }

    public static void setMovePoints(boolean movePoints) {
        Viewer.movePoints = movePoints;
    }

    public static VertexSelectionFactory.SelectionType getType() {
        return type;
    }

    public static void setType(VertexSelectionFactory.SelectionType type) {
        Viewer.type = type;
    }

    public static boolean isHighlightTopic() {
        return highlightTopic;
    }

    public static void setHighlightTopic(boolean highlightTopic) {
        Viewer.highlightTopic = highlightTopic;
    }

    public boolean isHighQualityRender() {
        return this.highQualityRender;
    }

    public void setHighQualityRender(boolean highQualityRender) {
        this.highQualityRender = highQualityRender;
    }

    public boolean isVertexLabelVisible() {
        return this.vertexLabelVisible;
    }

    public void setVertexLabelVisible(boolean isVertexLabelVisible) {
        this.vertexLabelVisible = isVertexLabelVisible;
    }

    public ProjectionExplorerView getProjectionExplorerView() {
        return this.pexview;
    }

    public int getId() {
        return this.id;
    }

    public Coordination getCoordination() {
        return this.coord;
    }

    public void createHCScalars(HierarchicalClusteringType type) {
        if (this.getGraph() != null) {
            try {
                JOptionPane.showMessageDialog(this, "The Hierachical Clustering is a very expensive process.\nIt can take several minutes!", "WARNING", 2);
                Scalar s = this.getGraph().createHC(type);
                this.updateScalars(s);
                this.setGraphChanged(true);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setGraphChanged(boolean graphChanged) {
        if (graphChanged) {
            if (!this.getTitle().endsWith("*")) {
                this.setTitle(this.getTitle() + "*");
            }
        } else if (this.getTitle().endsWith("*")) {
            this.setTitle(this.getTitle().substring(0, this.getTitle().length() - 1));
        }
        this.graphChanged = graphChanged;
    }

    public void setShowImages(boolean show) {
        JInternalFrame[] frames;
        Vertex.setShowTitle(false);
        Vertex.setShowContent(false);
        Vertex.setShowImage(show);
        Vertex.setShowLabel(false);
        for (JInternalFrame ifrm : frames = this.pexview.getDesktop().getAllFrames()) {
            if (!(ifrm instanceof Viewer)) continue;
            ((Viewer)ifrm).getProjectionExplorerView().refreshLists();
            ((Viewer)ifrm).updateImage();
        }
    }

    public void setShowVertexContent(boolean show) {
        JInternalFrame[] frames;
        Vertex.setShowContent(show);
        Vertex.setShowTitle(false);
        Vertex.setShowImage(false);
        Vertex.setShowLabel(false);
        for (JInternalFrame ifrm : frames = this.pexview.getDesktop().getAllFrames()) {
            if (!(ifrm instanceof Viewer)) continue;
            ((Viewer)ifrm).getProjectionExplorerView().refreshLists();
            ((Viewer)ifrm).updateImage();
        }
    }

    public void setShowVertexTitle(boolean show) {
        JInternalFrame[] frames;
        Vertex.setShowTitle(show);
        Vertex.setShowContent(false);
        Vertex.setShowImage(false);
        Vertex.setShowLabel(false);
        for (JInternalFrame ifrm : frames = this.pexview.getDesktop().getAllFrames()) {
            if (!(ifrm instanceof Viewer)) continue;
            ((Viewer)ifrm).getProjectionExplorerView().refreshLists();
            ((Viewer)ifrm).updateImage();
        }
    }
}

