/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.color;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visualizer.view.Viewer;
import visualizer.view.color.ColorScale;
import visualizer.view.color.ColorScalePanel;
import visualizer.view.color.ColorTable;
import visualizer.view.color.GrayScale;
import visualizer.view.color.HeatedObjectScale;
import visualizer.view.color.LinearGrayScale;
import visualizer.view.color.LocsScale;
import visualizer.view.color.RainbowScale;
import visualizer.view.color.UndefinedScale;

public class ColorScaleChange
extends JDialog {
    private ColorTable colorTable;
    private Viewer gv;
    private static ColorScaleChange instance;
    private ButtonGroup buttonGroup;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel coloScalePanel;
    private JPanel colorChosePanel;
    private JPanel colorPanel;
    private JRadioButton grayRadioButton;
    private JRadioButton heatedObjectsRadioButton;
    private JRadioButton linGrayRadioButton;
    private JRadioButton locsRadioButton;
    private JSlider maxSlider;
    private JSlider minSlider;
    private JRadioButton rainbowRadioButton;
    private JButton reverseButton;
    private JPanel scaleRangePanel;
    private JRadioButton undefinedRadioButton;

    private ColorScaleChange(JFrame parent, Viewer gv) {
        super(parent);
        this.gv = gv;
        this.initComponents();
        ((ColorScalePanel)this.coloScalePanel).setColorTable(this.gv.getColorTable());
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.colorPanel = new JPanel();
        this.scaleRangePanel = new JPanel();
        this.minSlider = new JSlider();
        this.maxSlider = new JSlider();
        this.coloScalePanel = new ColorScalePanel(this.gv);
        this.reverseButton = new JButton();
        this.colorChosePanel = new JPanel();
        this.undefinedRadioButton = new JRadioButton();
        this.grayRadioButton = new JRadioButton();
        this.heatedObjectsRadioButton = new JRadioButton();
        this.linGrayRadioButton = new JRadioButton();
        this.locsRadioButton = new JRadioButton();
        this.rainbowRadioButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Change the Color Scale");
        this.setModal(true);
        this.colorPanel.setLayout(new BorderLayout(3, 3));
        this.colorPanel.setBorder(BorderFactory.createTitledBorder("Color Scale"));
        this.scaleRangePanel.setLayout(new GridBagLayout());
        this.scaleRangePanel.setBorder(BorderFactory.createTitledBorder("Scale Range"));
        this.minSlider.setMaximum(50);
        this.minSlider.setPaintLabels(true);
        this.minSlider.setPaintTicks(true);
        this.minSlider.setInverted(true);
        this.minSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ColorScaleChange.this.minSliderStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.scaleRangePanel.add((Component)this.minSlider, gridBagConstraints);
        this.maxSlider.setMaximum(50);
        this.maxSlider.setPaintLabels(true);
        this.maxSlider.setPaintTicks(true);
        this.maxSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ColorScaleChange.this.maxSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.scaleRangePanel.add((Component)this.maxSlider, gridBagConstraints);
        this.coloScalePanel.setMinimumSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.scaleRangePanel.add((Component)this.coloScalePanel, gridBagConstraints);
        this.reverseButton.setText("Reverse Scale");
        this.reverseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.reverseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.scaleRangePanel.add((Component)this.reverseButton, gridBagConstraints);
        this.colorPanel.add((Component)this.scaleRangePanel, "South");
        this.colorChosePanel.setLayout(new GridBagLayout());
        this.buttonGroup.add(this.undefinedRadioButton);
        this.undefinedRadioButton.setSelected(true);
        this.undefinedRadioButton.setText("Undefined");
        this.undefinedRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.undefinedRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.undefinedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.undefinedRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.undefinedRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.grayRadioButton);
        this.grayRadioButton.setText("Gray");
        this.grayRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.grayRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.grayRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.grayRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.grayRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.heatedObjectsRadioButton);
        this.heatedObjectsRadioButton.setText("Heated Objetcs");
        this.heatedObjectsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.heatedObjectsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.heatedObjectsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.heatedObjectsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.heatedObjectsRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.linGrayRadioButton);
        this.linGrayRadioButton.setText("Linear Gray");
        this.linGrayRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.linGrayRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.linGrayRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.linGrayRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.linGrayRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.locsRadioButton);
        this.locsRadioButton.setText("LOCS");
        this.locsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.locsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.locsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.locsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.locsRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.rainbowRadioButton);
        this.rainbowRadioButton.setText("Rainbow");
        this.rainbowRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rainbowRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.rainbowRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.rainbowRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.rainbowRadioButton, gridBagConstraints);
        this.colorPanel.add((Component)this.colorChosePanel, "Center");
        this.getContentPane().add((Component)this.colorPanel, "Center");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void maxSliderStateChanged(ChangeEvent evt) {
        float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum();
        this.colorTable.getColorScale().setMax(max);
        if (this.gv != null) {
            this.gv.colorAs(this.gv.getCurrentScalar());
            this.gv.updateImage();
        }
        this.coloScalePanel.repaint();
    }

    private void minSliderStateChanged(ChangeEvent evt) {
        float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum();
        this.colorTable.getColorScale().setMin(1.0f - min);
        if (this.gv != null) {
            this.gv.colorAs(this.gv.getCurrentScalar());
            this.gv.updateImage();
        }
        this.coloScalePanel.repaint();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void reverseButtonActionPerformed(ActionEvent evt) {
        this.colorTable.getColorScale().setReverse(!this.colorTable.getColorScale().isReverse());
        float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum();
        this.colorTable.getColorScale().setMax(max);
        float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum();
        this.colorTable.getColorScale().setMin(1.0f - min);
        if (this.gv != null) {
            this.gv.colorAs(this.gv.getCurrentScalar());
            this.gv.updateImage();
        }
        this.coloScalePanel.repaint();
    }

    private void rainbowRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new RainbowScale());
    }

    private void locsRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new LocsScale());
    }

    private void linGrayRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new LinearGrayScale());
    }

    private void heatedObjectsRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new HeatedObjectScale());
    }

    private void grayRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new GrayScale());
    }

    private void undefinedRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new UndefinedScale());
    }

    public static ColorScaleChange getInstance(JFrame parent, Viewer gv) {
        if (instance == null || ColorScaleChange.instance.gv != gv) {
            instance = new ColorScaleChange(parent, gv);
        }
        return instance;
    }

    public void display() {
        this.colorTable = this.gv.getColorTable();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void changeColorScale(ColorScale scale) {
        this.colorTable.setColorScale(scale);
        float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum();
        this.colorTable.getColorScale().setMax(max);
        float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum();
        this.colorTable.getColorScale().setMin(1.0f - min);
        if (this.gv != null) {
            this.gv.colorAs(this.gv.getCurrentScalar());
            this.gv.updateImage();
        }
        this.coloScalePanel.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

