/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.util.SaveDialog;
import visualizer.util.filefilter.ZIPFilter;

public class ExportCorpus
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Scalar scalar;
    private Graph graph;
    private static ExportCorpus instance;
    private JRadioButton allDocumentsRadioButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel corporaLabel;
    private JTextField corporaTextField;
    private JButton exportButton;
    private ButtonGroup exportButtonGroup;
    private JPanel exportPanel;
    private JPanel parametersPanel;
    private JButton searchButton;
    private JRadioButton selectedColoredDocsRadioButton;
    private JRadioButton selectedNonColoredDocsRadioButton;

    private ExportCorpus(JFrame parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.exportButtonGroup = new ButtonGroup();
        this.parametersPanel = new JPanel();
        this.exportPanel = new JPanel();
        this.allDocumentsRadioButton = new JRadioButton();
        this.selectedColoredDocsRadioButton = new JRadioButton();
        this.selectedNonColoredDocsRadioButton = new JRadioButton();
        this.corporaLabel = new JLabel();
        this.corporaTextField = new JTextField();
        this.searchButton = new JButton();
        this.buttonPanel = new JPanel();
        this.exportButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Corpus");
        this.setModal(true);
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Parameters to Export"));
        this.parametersPanel.setLayout(new GridBagLayout());
        this.exportPanel.setBorder(BorderFactory.createTitledBorder("Export what?"));
        this.exportPanel.setLayout(new GridBagLayout());
        this.exportButtonGroup.add(this.allDocumentsRadioButton);
        this.allDocumentsRadioButton.setText("Export all documents");
        this.allDocumentsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.allDocumentsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.exportPanel.add((Component)this.allDocumentsRadioButton, gridBagConstraints);
        this.exportButtonGroup.add(this.selectedColoredDocsRadioButton);
        this.selectedColoredDocsRadioButton.setSelected(true);
        this.selectedColoredDocsRadioButton.setText("Export colored documents");
        this.selectedColoredDocsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.selectedColoredDocsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.exportPanel.add((Component)this.selectedColoredDocsRadioButton, gridBagConstraints);
        this.exportButtonGroup.add(this.selectedNonColoredDocsRadioButton);
        this.selectedNonColoredDocsRadioButton.setText("Export NO colored documents");
        this.selectedNonColoredDocsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.selectedNonColoredDocsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.exportPanel.add((Component)this.selectedNonColoredDocsRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.parametersPanel.add((Component)this.exportPanel, gridBagConstraints);
        this.corporaLabel.setText("Corpus name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.parametersPanel.add((Component)this.corporaLabel, gridBagConstraints);
        this.corporaTextField.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.parametersPanel.add((Component)this.corporaTextField, gridBagConstraints);
        this.searchButton.setText("Search...");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCorpus.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.parametersPanel.add((Component)this.searchButton, gridBagConstraints);
        this.getContentPane().add((Component)this.parametersPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.exportButton.setText("Export");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCorpus.this.exportButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.exportButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCorpus.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new ZIPFilter(), this);
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            this.corporaTextField.setText(filename);
        }
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        if (this.corporaTextField.getText().trim().length() > 0) {
            if (this.allDocumentsRadioButton.isSelected()) {
                this.graph.exportCorpus(this.corporaTextField.getText(), null, false);
            } else if (this.selectedColoredDocsRadioButton.isSelected()) {
                this.graph.exportCorpus(this.corporaTextField.getText(), this.scalar, false);
            } else {
                this.graph.exportCorpus(this.corporaTextField.getText(), this.scalar, true);
            }
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this, "A name for the new corpus must be provided!", "Error", 2);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static ExportCorpus getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new ExportCorpus(parent);
        }
        return instance;
    }

    public void display(Scalar scalar, Graph graph) {
        if (graph.getCorpus() != null) {
            this.graph = graph;
            this.scalar = scalar;
            this.corporaTextField.setText("");
            this.pack();
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.getParent(), "The original corpus must be chose!", "Error", 2);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ExportCorpus(null).setVisible(true);
            }
        });
    }
}

